/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.principalcomponents.swing.impl.stats;

import Jama.Matrix;
import java.text.DecimalFormat;
import org.cresques.Messages;
import org.gvsig.raster.principalcomponents.algorithm.PCStatsDataStructure;

public class ReportStatisticsProcessPCA {
    private boolean rowColor = true;
    private final String bgColor0 = "\"#FEEDD6\"";
    private final String bgColor1 = "\"#EAEAEA\"";
    private final String bgColor4 = "\"#D6D6D6\"";
    private final String bgColorBody = "\"#FFFFFF\"";
    public DecimalFormat df = null;
    public String html = "";
    private PCStatsDataStructure pcStatistics = null;
    private boolean bandStatistics = false;
    private boolean covar = false;
    private boolean autovect = false;

    public ReportStatisticsProcessPCA(PCStatsDataStructure pcStatistics, boolean bandStatistics, boolean covar, boolean autovect) {
        this.pcStatistics = pcStatistics;
        this.bandStatistics = bandStatistics;
        this.covar = covar;
        this.autovect = autovect;
        this.init();
    }

    public String getHtml() {
        return this.html;
    }

    public void init() {
        this.df = new DecimalFormat("0.00000");
        this.html = "<blockquote><blockquote><html><body>\t\t<body bgcolor=\"#FFFFFF\" topmargin=\"0\" marginheight=\"0\"><font size=3><h1><center>Informe estad\u00edstico de Componentes Principales</center></h1>";
        if (this.bandStatistics) {
            this.html = this.html + " <font face=\"Arial\" size=\"2\"><B>Estad\u00edsticas de bandas : </B><br>";
            this.CreateBandStatistic(this.pcStatistics.getMaxMinMean());
        }
        if (this.covar) {
            this.html = this.html + " <font face=\"Arial\" size=\"2\"><B>Matriz varianza-covarianza : </B><br>";
            this.ExportarMatriz(this.pcStatistics.getCoVarMatrix(), "Band");
        }
        if (this.autovect) {
            this.html = this.html + " <font face=\"Arial\" size=\"2\"><B>Matriz de autovectores : </B><br>";
            this.ExportarMatriz(this.ChangeColumns(this.pcStatistics.getAutoVectorsMatrix().transpose()), "Component");
        }
        this.close();
    }

    private Matrix ChangeColumns(Matrix m) {
        Matrix result = new Matrix(m.getRowDimension(), m.getColumnDimension());
        int k = m.getColumnDimension() - 1;
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                result.set(i, j, m.get(k - i, j));
            }
        }
        return result;
    }

    private void ExportarMatriz(Matrix Matrix2, String nameColumns) {
        int i;
        this.html = this.html + "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\"\">" + "<TR bgcolor=" + "\"#D6D6D6\"" + " ALIGN=center>";
        this.html = this.html + "<TH > <font face=\"Arial\" size=\"3\"><N></TH>";
        for (i = 0; i < Matrix2.getColumnDimension(); ++i) {
            this.html = this.html + "<TH > <font face=\"Arial\" size=\"3\" b> " + nameColumns + " " + (i + 1) + "</b></TH>";
        }
        this.html = this.html + "</TR>";
        for (i = 0; i < Matrix2.getRowDimension(); ++i) {
            this.html = this.html + "<TR ><TD bgcolor=" + "\"#D6D6D6\"" + "><center><font face=\"Arial\" size=\"3\">" + "<b>Band " + (i + 1) + " </b></TD>";
            String color = this.getColor();
            for (int j = 0; j < Matrix2.getColumnDimension(); ++j) {
                this.html = this.html + "<TD bgcolor=" + color + "><center><font face=\"Arial\" size=\"3\">" + this.df.format(Matrix2.get(i, j)) + " </TD>";
            }
            this.html = this.html + "</TR>";
        }
        this.html = this.html + "</TABLE><br><br>";
    }

    private void CreateBandStatistic(double[][] maxminmean) {
        this.html = this.html + "<table  width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" align=\"center\"\">" + "<TR bgcolor=" + "\"#D6D6D6\"" + " ALIGN=center>";
        this.html = this.html + "<TH><font face=\"Arial\" size=\"3\">" + Messages.getText((String)"band") + "</TH>" + "<TH> <font face=\"Arial\" size=\"3\"><N>" + Messages.getText((String)"max") + "</TH>" + "<TH><font face=\"Arial\" size=\"3\">" + Messages.getText((String)"min") + "</TH>" + "<TH><font face=\"Arial\" size=\"3\">" + Messages.getText((String)"mean") + "</TH>" + "<TH><font face=\"Arial\" size=\"3\">" + Messages.getText((String)"variance") + "</TH>" + "<TH><font face=\"Arial\" size=\"3\">" + Messages.getText((String)"standard_deviation") + "</N></TH></TR>";
        for (int i = 0; i < maxminmean.length; ++i) {
            this.html = this.html + "<TR bgcolor=" + this.getColor() + "><TD><center><font face=\"Arial\" size=\"3\">" + "band " + (i + 1) + " </TD>" + "<TD><center><font face=\"Arial\" size=\"3\">" + this.df.format(maxminmean[i][0]) + " </TD>" + "<TD><center><font face=\"Arial\" size=\"3\">" + this.df.format(maxminmean[i][1]) + " </TD>" + "<TD><center><font face=\"Arial\" size=\"3\">" + this.df.format(maxminmean[i][2]) + " </TD>" + "<TD><center><font face=\"Arial\" size=\"3\">" + this.df.format(maxminmean[i][3]) + " </TD>" + "<TD><center><font face=\"Arial\" size=\"3\">" + this.df.format(Math.sqrt(maxminmean[i][3])) + " </TD></TR>";
        }
        this.html = this.html + "</TABLE><br><br>";
    }

    public void close() {
        this.html = this.html + "</BODY></HTML>";
    }

    private String getColor() {
        String color = this.rowColor ? "\"#FEEDD6\"" : "\"#EAEAEA\"";
        this.rowColor = !this.rowColor;
        return color;
    }
}

