/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.sextante.gui.algorithm;

import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.exceptions.WrongOutputIDException;
import es.unex.sextante.gui.algorithm.DefaultParametersPanel;
import es.unex.sextante.gui.algorithm.OutputParameterContainer;
import es.unex.sextante.gui.algorithm.ParameterContainer;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import java.awt.Component;
import javax.swing.JPanel;
import org.gvsig.geoprocess.core.CompositeSourceOutputChannel;
import org.gvsig.geoprocess.lib.sextante.dataObjects.OutputParameters;
import org.gvsig.geoprocess.sextante.gui.algorithm.AlgorithmOutputPanel;

public class ParametersPanel
extends DefaultParametersPanel {
    private static final long serialVersionUID = 1L;

    protected void addOutputObjects(JPanel pane) {
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        this.m_iCurrentRow = 0;
        for (int i = 0; i < ooset.getOutputObjectsCount(); ++i) {
            Output out = ooset.getOutput(i);
            String sDescription = out.getDescription() + "[" + out.getTypeDescription() + "]";
            this.addTitleLabel(pane, sDescription, this.m_iCurrentRow, false);
            AlgorithmOutputPanel algorithmOutputPanel = new AlgorithmOutputPanel();
            pane.add((Component)algorithmOutputPanel, this.getStringTableCoords(2, this.m_iCurrentRow));
            ++this.m_iCurrentRow;
            this.m_OutputParameterContainer.add(new OutputParameterContainer(out.getName(), (Object)algorithmOutputPanel));
        }
    }

    public void assignParameters() {
        int i;
        boolean bAssigningOK = true;
        for (i = 0; i < this.m_ParameterContainer.size(); ++i) {
            ParameterContainer parameterContainer = (ParameterContainer)this.m_ParameterContainer.get(i);
            String sType = parameterContainer.getType();
            if (sType.equals("Table")) {
                bAssigningOK = this.assignInputTable(parameterContainer);
            } else if (sType.equals("Vector Layer") || sType.equals("Raster Layer")) {
                bAssigningOK = this.assignInputLayer(parameterContainer);
            } else if (sType.equals("Numerical Value")) {
                bAssigningOK = this.assignInputNumericalValue(parameterContainer);
            } else if (sType.equals("String")) {
                bAssigningOK = this.assignInputString(parameterContainer);
            } else if (sType.equals("Boolean")) {
                bAssigningOK = this.assignInputBoolean(parameterContainer);
            } else if (sType.equals("Fixed Table")) {
                bAssigningOK = this.assignInputFixedTable(parameterContainer);
            } else if (sType.equals("Multiple Input")) {
                bAssigningOK = this.assignInputMultipleInput(parameterContainer);
            } else if (sType.equals("Point")) {
                bAssigningOK = this.assignInputPoint(parameterContainer);
            } else if (parameterContainer.getType().equals("Filepath")) {
                bAssigningOK = this.assignInputFilepath(parameterContainer);
            } else if (sType.equals("Table Field") || sType.equals("Selection") || sType.equals("Band")) {
                bAssigningOK = this.assignInputSelection(parameterContainer);
            } else if (sType.equals("Table Filter")) {
                bAssigningOK = this.assignInputTableFilter(parameterContainer);
            }
            if (bAssigningOK) continue;
            return;
        }
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        for (i = 0; i < this.m_OutputParameterContainer.size(); ++i) {
            OutputParameterContainer opc = (OutputParameterContainer)this.m_OutputParameterContainer.get(i);
            try {
                Output out = ooset.getOutput(opc.getName());
                AlgorithmOutputPanel op = (AlgorithmOutputPanel)opc.getContainer();
                Object obj = op.getOutputParameters();
                if (obj == null) {
                    return;
                }
                if (!(obj instanceof OutputParameters)) continue;
                out.setOutputChannel((IOutputChannel)new CompositeSourceOutputChannel(obj));
                continue;
            }
            catch (WrongOutputIDException wrongOutputIDException) {
                // empty catch block
            }
        }
    }
}

