/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.PostfixCommand;

public class DayOfWeek
extends PostfixCommand {
    public final int getNumberOfParameters() {
        return 1;
    }

    public void evaluate(ASTFunNode aSTFunNode, JepRuntime jepRuntime) throws ParseException {
        aSTFunNode.childrenAccept(jepRuntime.ev, null);
        Comparable comparable = jepRuntime.stack.pop();
        jepRuntime.stack.push(DayOfWeek.dayOfWeek(comparable, jepRuntime.calendar));
    }

    public static Integer dayOfWeek(Comparable comparable, Calendar calendar) throws ParseException {
        if (comparable == null) {
            return null;
        }
        if (comparable instanceof Timestamp || comparable instanceof java.sql.Date) {
            Date date = (Date)comparable;
            calendar.setTimeInMillis(date.getTime());
            int n = calendar.get(7) - 1;
            if (n == 0) {
                n = 7;
            }
            return new Integer(n);
        }
        throw new ParseException("Wrong type dayofweek(" + comparable.getClass() + ")");
    }
}

