/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.math.BigDecimal;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.PostfixCommand;

public class Floor
extends PostfixCommand {
    public final int getNumberOfParameters() {
        return 1;
    }

    public void evaluate(ASTFunNode aSTFunNode, JepRuntime jepRuntime) throws ParseException {
        aSTFunNode.childrenAccept(jepRuntime.ev, null);
        Comparable comparable = jepRuntime.stack.pop();
        jepRuntime.stack.push(Floor.floor(comparable));
    }

    public static Comparable floor(Comparable comparable) throws ParseException {
        if (comparable == null) {
            return null;
        }
        if (comparable instanceof String) {
            comparable = Floor.parse((String)((Object)comparable));
        }
        if (comparable instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)comparable).setScale(0, 3);
            try {
                return Long.valueOf(bigDecimal.longValueExact());
            }
            catch (ArithmeticException arithmeticException) {
                return bigDecimal;
            }
        }
        if (comparable instanceof Double || comparable instanceof Float) {
            return Double.valueOf(Math.floor(((Number)((Object)comparable)).doubleValue()));
        }
        if (comparable instanceof Number) {
            return comparable;
        }
        throw new ParseException("Wrong type floor(" + comparable.getClass() + ")");
    }
}

