/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import org.medfoster.sqljep.function.OracleDateFormat;
import org.medfoster.sqljep.function.OracleTimeFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTimestampFormat
extends Format {
    private static final String PATTERN_EXCEPTION = "Wrong pattern";
    private static final String FORMAT_EXCEPTION = "Wrong pattern";
    private static final String NOT_IMPLIMENTED_EXCEPTION = "Not implimented";
    private static final String BAD_INPUT_PATTERN = "Format code cannot appear in date input format";
    private static final String BAD_HH12 = "Hour must be between 1 and 12";
    protected static final Hashtable<String, ArrayList<Object>> formatsCache = new Hashtable();
    protected static final ArrayList<DATE> dateSymbols = new ArrayList();
    protected static final ArrayList<DATE> timeSymbols = new ArrayList();
    protected ArrayList<Object> format = null;
    protected Calendar cal;
    protected DateFormatSymbols symb;

    protected OracleTimestampFormat() {
    }

    public OracleTimestampFormat(String string) throws ParseException {
        this.cal = Calendar.getInstance();
        this.symb = new DateFormatSymbols();
        this.format = formatsCache.get(string);
        if (this.format == null) {
            this.format = new ArrayList();
            ArrayList arrayList = (ArrayList)dateSymbols.clone();
            arrayList.addAll(timeSymbols);
            OracleTimestampFormat.compilePattern(this.format, arrayList, string);
            formatsCache.put(string, this.format);
        }
    }

    public OracleTimestampFormat(String string, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
        this.cal = calendar;
        this.symb = dateFormatSymbols;
        this.format = formatsCache.get(string);
        if (this.format == null) {
            this.format = new ArrayList();
            ArrayList arrayList = (ArrayList)dateSymbols.clone();
            arrayList.addAll(timeSymbols);
            OracleTimestampFormat.compilePattern(this.format, arrayList, string);
            formatsCache.put(string, this.format);
        }
    }

    public OracleTimeFormat getTimeFormat() {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        int n3 = arrayList.size();
        for (n = 0; n < arrayList.size(); ++n) {
            Object object = this.format.get(n);
            if (!(object instanceof TIME)) continue;
            if (n > n2) {
                n2 = n;
                continue;
            }
            if (n >= n3) continue;
            n3 = n;
        }
        for (n = n2; n < n3; ++n) {
            arrayList.add(this.format.get(n));
        }
        return new OracleTimeFormat(arrayList, this.cal, this.symb);
    }

    public OracleDateFormat getDateFormat() {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        int n3 = arrayList.size();
        for (n = 0; n < arrayList.size(); ++n) {
            Object object = this.format.get(n);
            if (!(object instanceof DATE)) continue;
            if (n > n2) {
                n2 = n;
                continue;
            }
            if (n >= n3) continue;
            n3 = n;
        }
        for (n = n2; n < n3; ++n) {
            arrayList.add(this.format.get(n));
        }
        return new OracleDateFormat(arrayList, this.cal, this.symb);
    }

    public String toString() {
        if (this.format != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Object object : this.format) {
                stringBuilder.append(object.toString());
            }
            return stringBuilder.toString();
        }
        return "null";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OracleTimestampFormat oracleTimestampFormat = (OracleTimestampFormat)object;
        return this.format != null ? this.format.equals(oracleTimestampFormat.format) : false;
    }

    protected static void compilePattern(ArrayList<Object> arrayList, ArrayList<DATE> arrayList2, String string) throws ParseException {
        if (string == null) {
            throw new ParseException("Wrong pattern", 0);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            boolean bl = false;
            for (DATE dATE : arrayList2) {
                String string2 = dATE.toString();
                if (n2 + string2.length() > n || !string.regionMatches(true, n2, string2, 0, string2.length())) continue;
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                arrayList.add(dATE);
                n2 += string2.length();
                bl = true;
                break;
            }
            if (bl) continue;
            char c = string.charAt(n2);
            if (!Character.isLetterOrDigit(c)) {
                stringBuilder.append(c);
                ++n2;
                continue;
            }
            throw new ParseException("Wrong pattern", n2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            Date date = (Date)object;
            this.cal.setTime(date);
            if (this.format != null) {
                for (Object object2 : this.format) {
                    if (object2 instanceof String) {
                        stringBuffer.append((String)object2);
                        continue;
                    }
                    DATE dATE = (DATE)object2;
                    try {
                        dATE.toString(stringBuffer, this.cal, this.symb);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return stringBuffer;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return new Timestamp(this.parseInMillis(string, parsePosition));
    }

    protected long parseInMillis(String string, ParsePosition parsePosition) {
        int n = this.cal.get(1);
        int n2 = this.cal.get(2);
        this.cal.clear();
        this.cal.set(1, n);
        this.cal.set(2, n2);
        int n3 = string.length();
        try {
            if (this.format != null) {
                for (Object object : this.format) {
                    if (!(object instanceof DATE)) continue;
                    DATE dATE = (DATE)object;
                    dATE.parse(this.cal, this.symb, string, parsePosition);
                }
                for (int i = parsePosition.getIndex(); i < n3; ++i) {
                    char c = string.charAt(i);
                    if (!Character.isLetterOrDigit(c)) continue;
                    throw new ParseException("Wrong pattern", 0);
                }
                parsePosition.setIndex(n3);
            }
        }
        catch (Exception exception) {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            parsePosition.setIndex(0);
            return 0L;
        }
        return this.cal.getTimeInMillis();
    }

    private static char getSign(String string, ParsePosition parsePosition) throws ParseException {
        int n;
        int n2 = string.length();
        for (n = parsePosition.getIndex(); n < n2; ++n) {
            char c = string.charAt(n);
            if (c == '-' || c == '+') {
                parsePosition.setIndex(n);
                return c;
            }
            if (Character.isDigit(c)) {
                parsePosition.setIndex(n);
                return '+';
            }
            if (!Character.isLetter(c)) continue;
            parsePosition.setIndex(n);
            throw new ParseException("", n);
        }
        throw new ParseException("", n);
    }

    private static int getNumber(String string, ParsePosition parsePosition, int n) throws ParseException, NumberFormatException {
        char c;
        int n2;
        int n3 = string.length();
        String string2 = "";
        for (n2 = parsePosition.getIndex(); n2 < n3 && !Character.isDigit(c = string.charAt(n2)); ++n2) {
            if (!Character.isLetter(c)) continue;
            parsePosition.setIndex(n2);
            throw new ParseException("", n2);
        }
        while (n2 < n3) {
            c = string.charAt(n2);
            if (Character.isDigit(c)) {
                if ((string2 = string2 + c).length() == n) {
                    parsePosition.setIndex(n2 + 1);
                    return Integer.valueOf(string2);
                }
            } else {
                if (!Character.isLetter(c)) break;
                parsePosition.setIndex(n2);
                throw new ParseException("", n2);
            }
            ++n2;
        }
        parsePosition.setIndex(n2);
        return Integer.valueOf(string2);
    }

    static {
        dateSymbols.add(new fBC());
        dateSymbols.add(new fAD());
        dateSymbols.add(new BdCd());
        dateSymbols.add(new AdDd());
        dateSymbols.add(new SCC());
        dateSymbols.add(new CC());
        dateSymbols.add(new SYYYY());
        dateSymbols.add(new YYYY());
        dateSymbols.add(new YcYYY());
        dateSymbols.add(new YYY());
        dateSymbols.add(new YY());
        dateSymbols.add(new Y());
        dateSymbols.add(new SYEAR());
        dateSymbols.add(new YEAR());
        dateSymbols.add(new IYYY());
        dateSymbols.add(new IY());
        dateSymbols.add(new I());
        dateSymbols.add(new RRRR());
        dateSymbols.add(new RR());
        dateSymbols.add(new Q());
        dateSymbols.add(new MONTH());
        dateSymbols.add(new MON());
        dateSymbols.add(new MM());
        dateSymbols.add(new RM());
        dateSymbols.add(new WW());
        dateSymbols.add(new IW());
        dateSymbols.add(new DAY());
        dateSymbols.add(new DY());
        dateSymbols.add(new DDD());
        dateSymbols.add(new DD());
        dateSymbols.add(new D());
        dateSymbols.add(new J());
        timeSymbols.add(new HH12());
        timeSymbols.add(new HH24());
        timeSymbols.add(new HH());
        timeSymbols.add(new fAM());
        timeSymbols.add(new fPM());
        timeSymbols.add(new PdMd());
        timeSymbols.add(new AdMd());
        timeSymbols.add(new MI());
        timeSymbols.add(new SSSSS());
        timeSymbols.add(new SS());
    }

    public static final class SS
    extends TIME {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(13);
            String string = Integer.toString(n);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 2);
            calendar.set(13, n);
        }

        public String toString() {
            return "SS";
        }
    }

    public static final class SSSSS
    extends TIME {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(10);
            int n2 = calendar.get(12);
            int n3 = calendar.get(13);
            String string = Integer.toString(n * 60 * 60 + n2 * 60 + n3);
            for (int i = string.length(); i < 5; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 5);
            int n2 = n / 3600;
            int n3 = (n -= n2) / 60;
            int n4 = n - n3;
            calendar.set(10, n2);
            calendar.set(12, n3);
            calendar.set(13, n4);
        }

        public String toString() {
            return "SSSSS";
        }
    }

    public static final class MI
    extends TIME {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(12);
            String string = Integer.toString(n);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 2);
            calendar.set(12, n);
        }

        public String toString() {
            return "MI";
        }
    }

    public static final class AdMd
    extends TIME {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(9);
            stringBuffer.append(n == 0 ? "a.m." : "p.m.");
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = parsePosition.getIndex();
            String string2 = string.substring(n, n + 4);
            if (this.toString().equals(string2.toUpperCase())) {
                parsePosition.setIndex(n + 4);
                calendar.set(9, 0);
            } else if (string2.toUpperCase().equals("P.M.")) {
                parsePosition.setIndex(n + 4);
                calendar.set(9, 1);
            } else {
                throw new ParseException("", 0);
            }
        }

        public String toString() {
            return "A.M.";
        }
    }

    public static final class PdMd
    extends TIME {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(9);
            stringBuffer.append(n == 0 ? "a.m." : "p.m.");
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = parsePosition.getIndex();
            String string2 = string.substring(n, n + 4);
            if (this.toString().equals(string2.toUpperCase())) {
                parsePosition.setIndex(n + 4);
                calendar.set(9, 1);
            } else if (string2.toUpperCase().equals("A.M.")) {
                parsePosition.setIndex(n + 4);
                calendar.set(9, 0);
            } else {
                throw new ParseException("", 0);
            }
        }

        public String toString() {
            return "P.M.";
        }
    }

    public static final class fPM
    extends TIME {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            String[] stringArray = dateFormatSymbols.getAmPmStrings();
            int n = calendar.get(9);
            stringBuffer.append(stringArray[n]);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            String[] stringArray = dateFormatSymbols.getAmPmStrings();
            int n = parsePosition.getIndex();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = stringArray[i].length();
                if (!string.regionMatches(true, n, stringArray[i], 0, n2)) continue;
                parsePosition.setIndex(n + n2);
                calendar.set(0, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "PM";
        }
    }

    public static final class fAM
    extends TIME {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            String[] stringArray = dateFormatSymbols.getAmPmStrings();
            int n = calendar.get(9);
            stringBuffer.append(stringArray[n]);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            String[] stringArray = dateFormatSymbols.getAmPmStrings();
            int n = parsePosition.getIndex();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = stringArray[i].length();
                if (!string.regionMatches(true, n, stringArray[i], 0, n2)) continue;
                parsePosition.setIndex(n + n2);
                calendar.set(0, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "AM";
        }
    }

    public static final class HH
    extends TIME {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(10);
            String string = Integer.toString(n);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 2);
            if (n <= 0 || n >= 13) {
                throw new ParseException(OracleTimestampFormat.BAD_HH12, 0);
            }
            calendar.set(10, n);
        }

        public String toString() {
            return "HH";
        }
    }

    public static final class HH24
    extends TIME {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(11);
            String string = Integer.toString(n);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 2);
            calendar.set(11, n);
        }

        public String toString() {
            return "HH24";
        }
    }

    public static final class HH12
    extends TIME {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(10);
            String string = Integer.toString(n);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 2);
            if (n <= 0 || n >= 13) {
                throw new ParseException(OracleTimestampFormat.BAD_HH12, 0);
            }
            calendar.set(10, n);
        }

        public String toString() {
            return "HH12";
        }
    }

    public static final class J
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "J";
        }
    }

    public static final class D
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(7);
            int n2 = n - calendar.getFirstDayOfWeek();
            String string = Integer.toString(n2 < 0 ? 7 : n2 + 1);
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 1);
        }

        public String toString() {
            return "D";
        }
    }

    public static final class DD
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(5);
            String string = Integer.toString(n);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 2);
            calendar.set(5, n);
        }

        public String toString() {
            return "DD";
        }
    }

    public static final class DDD
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(6);
            String string = Integer.toString(n);
            for (int i = string.length(); i < 3; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 3);
            calendar.set(6, n);
        }

        public String toString() {
            return "DDD";
        }
    }

    public static final class DY
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(7);
            String[] stringArray = dateFormatSymbols.getShortWeekdays();
            stringBuffer.append(stringArray[n]);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            String[] stringArray = dateFormatSymbols.getShortWeekdays();
            int n = parsePosition.getIndex();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = stringArray[i].length();
                if (!string.regionMatches(true, n, stringArray[i], 0, n2)) continue;
                parsePosition.setIndex(n + n2);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "DY";
        }
    }

    public static final class DAY
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(7);
            String[] stringArray = dateFormatSymbols.getWeekdays();
            stringBuffer.append(stringArray[n]);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            String[] stringArray = dateFormatSymbols.getWeekdays();
            int n = parsePosition.getIndex();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = stringArray[i].length();
                if (!string.regionMatches(true, n, stringArray[i], 0, n2)) continue;
                parsePosition.setIndex(n + n2);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "DAY";
        }
    }

    public static final class IW
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "IW";
        }
    }

    public static final class WW
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(3);
            String string = Integer.toString(n);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "WW";
        }
    }

    public static final class RM
    extends DATE {
        private static final String[] rmonths = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII"};

        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(2);
            stringBuffer.append(rmonths[n]);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = parsePosition.getIndex();
            for (int i = 0; i < rmonths.length; ++i) {
                int n2 = rmonths[i].length();
                if (!string.regionMatches(true, n, rmonths[i], 0, n2)) continue;
                parsePosition.setIndex(n + n2);
                calendar.set(2, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "RM";
        }
    }

    public static final class MM
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(2) + 1;
            String string = Integer.toString(n);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 2) - 1;
            calendar.set(2, n);
        }

        public String toString() {
            return "MM";
        }
    }

    public static final class MON
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(2);
            String[] stringArray = dateFormatSymbols.getShortMonths();
            stringBuffer.append(stringArray[n]);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            String[] stringArray = dateFormatSymbols.getShortMonths();
            int n = parsePosition.getIndex();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = stringArray[i].length();
                if (!string.regionMatches(true, n, stringArray[i], 0, n2)) continue;
                parsePosition.setIndex(n + n2);
                calendar.set(2, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "MON";
        }
    }

    public static final class MONTH
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(2);
            String[] stringArray = dateFormatSymbols.getMonths();
            stringBuffer.append(stringArray[n]);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            String[] stringArray = dateFormatSymbols.getMonths();
            int n = parsePosition.getIndex();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = stringArray[i].length();
                if (!string.regionMatches(true, n, stringArray[i], 0, n2)) continue;
                parsePosition.setIndex(n + n2);
                calendar.set(2, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "MONTH";
        }
    }

    public static final class Q
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(2);
            String string = Integer.toString(n / 3 * 3);
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "Q";
        }
    }

    public static final class RR
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "RR";
        }
    }

    public static final class RRRR
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "RRRR";
        }
    }

    public static final class I
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "I";
        }
    }

    public static final class IY
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "IY";
        }
    }

    public static final class IYYY
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public String toString() {
            return "IYYY";
        }
    }

    public static final class YEAR
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "YEAR";
        }
    }

    public static final class SYEAR
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            throw new ParseException(OracleTimestampFormat.NOT_IMPLIMENTED_EXCEPTION, 0);
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "SYEAR";
        }
    }

    public static final class Y
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(1);
            String string = Integer.toString(n - n / 10 * 10);
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 1);
            int n2 = calendar.get(1) / 10 * 10;
            calendar.set(1, n2 + n);
        }

        public String toString() {
            return "Y";
        }
    }

    public static final class YY
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(1);
            String string = Integer.toString(n - n / 100 * 100);
            for (int i = string.length(); i < 2; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 2);
            int n2 = calendar.get(1) / 100 * 100;
            calendar.set(1, n2 + n);
        }

        public String toString() {
            return "YY";
        }
    }

    public static final class YYY
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(1);
            String string = Integer.toString(n - n / 1000 * 1000);
            for (int i = string.length(); i < 3; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 3);
            int n2 = calendar.get(1) / 1000 * 1000;
            calendar.set(1, n2 + n);
        }

        public String toString() {
            return "YYY";
        }
    }

    public static final class YcYYY
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(1);
            String string = Integer.toString(n / 1000);
            stringBuffer.append(string + ',');
            String string2 = Integer.toString(n - n / 1000 * 1000);
            for (int i = string.length(); i < 3; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string2);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n;
            OracleTimestampFormat.getNumber(string, parsePosition, 1);
            int n2 = parsePosition.getIndex();
            String string2 = string.charAt(n2 - 1) + "";
            if (string.charAt(n2) == ',') {
                parsePosition.setIndex(++n2);
                OracleTimestampFormat.getNumber(string, parsePosition, 3);
                string2 = string2 + string.substring(n2, parsePosition.getIndex());
                n = Integer.valueOf(string2);
            } else {
                parsePosition.setIndex(n2 - 1);
                n = OracleTimestampFormat.getNumber(string, parsePosition, 4);
            }
            calendar.set(1, n);
        }

        public String toString() {
            return "Y,YYY";
        }
    }

    public static final class YYYY
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(1);
            String string = Integer.toString(Math.abs(n));
            for (int i = string.length(); i < 4; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 4);
            calendar.set(1, n);
        }

        public String toString() {
            return "YYYY";
        }
    }

    public static final class SYYYY
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(1);
            String string = Integer.toString(n);
            for (int i = string.length(); i < 4; ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            boolean bl = false;
            if (OracleTimestampFormat.getSign(string, parsePosition) == '-') {
                bl = true;
            }
            int n = OracleTimestampFormat.getNumber(string, parsePosition, 4);
            if (bl) {
                n = -n;
            }
            calendar.set(1, n);
        }

        public String toString() {
            return "SYYYY";
        }
    }

    public static final class CC
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(1);
            String string = Integer.toString(Math.abs(n / 100 * 100));
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "CC";
        }
    }

    public static final class SCC
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(1);
            String string = Integer.toString(n / 100 * 100);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            throw new ParseException(OracleTimestampFormat.BAD_INPUT_PATTERN, 0);
        }

        public String toString() {
            return "SCC";
        }
    }

    public static final class AdDd
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(0);
            stringBuffer.append(n == 1 ? "a.d." : "b.c.");
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = parsePosition.getIndex();
            String string2 = string.substring(n, n + 4);
            if (this.toString().equals(string2.toUpperCase())) {
                parsePosition.setIndex(n + 4);
                calendar.set(0, 1);
            } else if (string2.toUpperCase().equals("B.C.")) {
                parsePosition.setIndex(n + 4);
                calendar.set(0, 0);
            } else {
                throw new ParseException("", 0);
            }
        }

        public String toString() {
            return "A.D.";
        }
    }

    public static final class BdCd
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            int n = calendar.get(0);
            stringBuffer.append(n == 0 ? "b.c." : "a.d.");
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            int n = parsePosition.getIndex();
            String string2 = string.substring(n, n + 4);
            if (this.toString().equals(string2.toUpperCase())) {
                parsePosition.setIndex(n + 4);
                calendar.set(0, 0);
            } else if (string2.toUpperCase().equals("A.D.")) {
                parsePosition.setIndex(n + 4);
                calendar.set(0, 1);
            } else {
                throw new ParseException("", 0);
            }
        }

        public String toString() {
            return "B.C.";
        }
    }

    public static final class fAD
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            String[] stringArray = dateFormatSymbols.getEras();
            int n = calendar.get(0);
            stringBuffer.append(stringArray[n]);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            String[] stringArray = dateFormatSymbols.getEras();
            int n = parsePosition.getIndex();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = stringArray[i].length();
                if (!string.regionMatches(true, n, stringArray[i], 0, n2)) continue;
                parsePosition.setIndex(n + n2);
                calendar.set(0, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "AD";
        }
    }

    public static final class fBC
    extends DATE {
        public StringBuffer toString(StringBuffer stringBuffer, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
            String[] stringArray = dateFormatSymbols.getEras();
            int n = calendar.get(0);
            stringBuffer.append(stringArray[n]);
            return stringBuffer;
        }

        public void parse(Calendar calendar, DateFormatSymbols dateFormatSymbols, String string, ParsePosition parsePosition) throws ParseException {
            String[] stringArray = dateFormatSymbols.getEras();
            int n = parsePosition.getIndex();
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = stringArray[i].length();
                if (!string.regionMatches(false, n, stringArray[i], 0, n2)) continue;
                parsePosition.setIndex(n + n2);
                calendar.set(0, i);
                return;
            }
            throw new ParseException("", 0);
        }

        public String toString() {
            return "BC";
        }
    }

    public static abstract class TIME
    extends DATE {
    }

    public static abstract class DATE {
        public abstract StringBuffer toString(StringBuffer var1, Calendar var2, DateFormatSymbols var3) throws ParseException;

        public abstract void parse(Calendar var1, DateFormatSymbols var2, String var3, ParsePosition var4) throws ParseException;

        public boolean equals(Comparable comparable) {
            if (comparable == null) {
                return false;
            }
            return comparable.getClass() == this.getClass();
        }
    }
}

