/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.math.BigDecimal;
import java.util.Stack;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.PostfixCommandI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PostfixCommand
implements PostfixCommandI {
    protected static final Integer ZERO = new Integer(0);
    public static final String PARAMS_NUMBER = "Wrong number of parameters";
    public static final String WRONG_TYPE = "Wrong type";
    public static final String INTERNAL_ERROR = "Internal error";
    public static final String NOT_IMPLIMENTED_EXCEPTION = "Not implimented";

    @Override
    public abstract int getNumberOfParameters();

    @Override
    public abstract void evaluate(ASTFunNode var1, JepRuntime var2) throws ParseException;

    protected final void removeParams(Stack<Comparable> stack, int n) {
        stack.pop();
        for (int i = 1; i < n; ++i) {
            stack.pop();
        }
        stack.push(null);
    }

    public static Comparable parse(String string) throws ParseException {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                BigDecimal bigDecimal = new BigDecimal(string);
                if (bigDecimal.scale() < 0) {
                    bigDecimal = bigDecimal.setScale(0);
                }
                return bigDecimal;
            }
            catch (NumberFormatException numberFormatException2) {
                throw new ParseException("Not a number");
            }
        }
    }

    public static BigDecimal getBigDecimal(Number number) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Double || number instanceof Float) {
            return new BigDecimal(number.doubleValue());
        }
        return new BigDecimal(number.longValue());
    }

    public static int getInteger(Comparable comparable) throws ParseException {
        if (comparable instanceof Number) {
            return ((Number)((Object)comparable)).intValue();
        }
        if (comparable instanceof String) {
            try {
                BigDecimal bigDecimal = new BigDecimal((String)((Object)comparable));
                return bigDecimal.intValueExact();
            }
            catch (Exception exception) {
                throw new ParseException("Cant parse integer: '" + (String)((Object)comparable) + "'");
            }
        }
        throw new ParseException("Not Integer: " + (comparable != null ? comparable.getClass() : "null"));
    }

    public static double getDouble(Comparable comparable) throws ParseException {
        if (comparable instanceof Number) {
            Number number = (Number)((Object)comparable);
            return number.doubleValue();
        }
        if (comparable instanceof String) {
            try {
                return Double.valueOf((String)((Object)comparable));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Cant parse double: '" + (String)((Object)comparable) + "'");
            }
        }
        throw new ParseException("Not Double: " + (comparable != null ? comparable.getClass() : "null"));
    }
}

