/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.math.BigDecimal;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.PostfixCommand;

public class Power
extends PostfixCommand {
    public final int getNumberOfParameters() {
        return 2;
    }

    public void evaluate(ASTFunNode aSTFunNode, JepRuntime jepRuntime) throws ParseException {
        aSTFunNode.childrenAccept(jepRuntime.ev, null);
        Comparable comparable = jepRuntime.stack.pop();
        Comparable comparable2 = jepRuntime.stack.pop();
        jepRuntime.stack.push(Power.power(comparable2, comparable));
    }

    public static Comparable power(Comparable comparable, Comparable comparable2) throws ParseException {
        if (comparable == null || comparable2 == null) {
            return null;
        }
        if (comparable instanceof String) {
            comparable = Power.parse((String)((Object)comparable));
        }
        if (comparable2 instanceof String) {
            comparable2 = Power.parse((String)((Object)comparable2));
        }
        if (comparable instanceof Number && comparable2 instanceof Number) {
            double d;
            int n = ((Number)((Object)comparable2)).intValue();
            if ((double)n == (d = ((Number)((Object)comparable2)).doubleValue())) {
                long l;
                int n2;
                if (comparable instanceof BigDecimal) {
                    try {
                        return ((BigDecimal)comparable).pow(n2);
                    }
                    catch (ArithmeticException arithmeticException) {
                        throw new ParseException(arithmeticException.getMessage());
                    }
                }
                if (comparable instanceof Double || comparable instanceof Float) {
                    return Double.valueOf(Math.pow(((Number)((Object)comparable)).doubleValue(), n2));
                }
                long l2 = l = ((Number)((Object)comparable)).longValue();
                for (n2 = n; n2 > 1; --n2) {
                    long l3;
                    if ((l2 *= l) >= (l3 = l2)) continue;
                    return Double.valueOf(Math.pow(l, n2));
                }
                if (l2 >= 0L) {
                    return Long.valueOf(l2);
                }
            }
            throw new ParseException("Power should be integer value");
        }
        throw new ParseException("Wrong type  power(" + comparable.getClass() + "," + comparable2.getClass() + ")");
    }
}

