/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.PostfixCommand;

public class Round
extends PostfixCommand {
    private static final String PARAM_EXCEPTION = "Scale in round shoud be integer";

    public final int getNumberOfParameters() {
        return -1;
    }

    public void evaluate(ASTFunNode aSTFunNode, JepRuntime jepRuntime) throws ParseException {
        aSTFunNode.childrenAccept(jepRuntime.ev, null);
        int n = aSTFunNode.jjtGetNumChildren();
        if (n == 1) {
            Comparable comparable = jepRuntime.stack.pop();
            jepRuntime.stack.push(Round.round(comparable, jepRuntime.calendar));
        } else if (n == 2) {
            Comparable comparable = jepRuntime.stack.pop();
            Comparable comparable2 = jepRuntime.stack.pop();
            jepRuntime.stack.push(Round.round(comparable2, comparable, jepRuntime.calendar));
        } else {
            this.removeParams(jepRuntime.stack, n);
            throw new ParseException("Wrong number of parameters for trunc");
        }
    }

    public static Comparable round(Comparable comparable, Calendar calendar) throws ParseException {
        if (comparable == null) {
            return null;
        }
        if (comparable instanceof String) {
            comparable = Round.parse((String)((Object)comparable));
        }
        if (comparable instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)comparable).setScale(0, 4);
            try {
                return Long.valueOf(bigDecimal.longValueExact());
            }
            catch (ArithmeticException arithmeticException) {
                return bigDecimal;
            }
        }
        if (comparable instanceof Double || comparable instanceof Float) {
            return Long.valueOf(Math.round(((Number)((Object)comparable)).doubleValue()));
        }
        if (comparable instanceof Number) {
            return comparable;
        }
        if (comparable instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)comparable;
            calendar.setTimeInMillis(timestamp.getTime());
            int n = calendar.get(1);
            int n2 = calendar.get(2);
            int n3 = calendar.get(5);
            int n4 = calendar.get(11);
            calendar.clear();
            if (n4 > 11) {
                ++n3;
            }
            calendar.set(n, n2, n3);
            return new Timestamp(calendar.getTimeInMillis());
        }
        throw new ParseException("Wrong type round(" + comparable.getClass() + ")");
    }

    public static Comparable round(Comparable comparable, Comparable comparable2, Calendar calendar) throws ParseException {
        if (comparable == null || comparable2 == null) {
            return null;
        }
        if (comparable instanceof String) {
            comparable = Round.parse((String)((Object)comparable));
        }
        if (comparable instanceof Number) {
            int n;
            try {
                n = Round.getInteger(comparable2);
            }
            catch (ParseException parseException) {
                throw new ParseException(PARAM_EXCEPTION);
            }
            if (n < 0) {
                return ZERO;
            }
            if (comparable instanceof BigDecimal) {
                return ((BigDecimal)comparable).setScale(n, 4);
            }
            if (comparable instanceof Double || comparable instanceof Float) {
                double d = ((Number)((Object)comparable)).doubleValue();
                long l = 1L;
                for (int i = 0; i < n; ++i) {
                    l *= 10L;
                }
                return Long.valueOf(Math.round(d *= (double)l) / l);
            }
            if (comparable instanceof Number) {
                return comparable;
            }
            throw new ParseException("Wrong type round(" + comparable.getClass() + "," + comparable2.getClass() + ")");
        }
        if (comparable instanceof Date && comparable2 instanceof String) {
            String string = (String)((Object)comparable2);
            Date date = (Date)comparable;
            calendar.setTimeInMillis(date.getTime());
            if (string.equalsIgnoreCase("CC") || string.equalsIgnoreCase("SCC")) {
                int n;
                if (date instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int n2 = calendar.get(1);
                if (n2 - (n = n2 / 100 * 100) > 50) {
                    n += 100;
                }
                calendar.clear();
                calendar.set(n + 1, 0, 1);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("SYYYY") || string.equalsIgnoreCase("YYYY") || string.equalsIgnoreCase("YYY") || string.equalsIgnoreCase("Y") || string.equalsIgnoreCase("YEAR") || string.equalsIgnoreCase("SYEAR")) {
                if (date instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int n = calendar.get(1);
                int n3 = calendar.get(2);
                if (n3 > 6) {
                    ++n;
                }
                calendar.clear();
                calendar.set(n, 0, 1);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("IYYY") || string.equalsIgnoreCase("IY") || string.equalsIgnoreCase("I")) {
                throw new ParseException("Not implimented");
            }
            if (string.equalsIgnoreCase("Q")) {
                int n;
                int n4;
                if (date instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int n5 = calendar.get(1);
                int n6 = calendar.get(2);
                if (n6 > (n4 = n6 / 3 * 3) + 1) {
                    ++n4;
                } else if (n6 > n4 && (n = calendar.get(5)) > 15) {
                    ++n4;
                }
                calendar.clear();
                calendar.set(n5, n4, 1);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("MONTH") || string.equalsIgnoreCase("MON") || string.equalsIgnoreCase("MM") || string.equalsIgnoreCase("RM")) {
                if (date instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int n = calendar.get(1);
                int n7 = calendar.get(2);
                int n8 = calendar.get(5);
                if (n8 > 15) {
                    ++n7;
                }
                calendar.clear();
                calendar.set(n, n7, 1);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("WW")) {
                int n;
                if (date instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int n9 = calendar.get(1);
                int n10 = calendar.get(2);
                int n11 = calendar.get(5);
                int n12 = calendar.get(7);
                calendar.clear();
                calendar.set(n9, 0, 1);
                int n13 = calendar.get(7);
                int n14 = n = n12 < n13 ? 7 - (n13 - n12) : n12 - n13;
                if (n > 2) {
                    n -= 7;
                }
                calendar.set(n9, n10, n11 - n);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("W")) {
                int n;
                if (date instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int n15 = calendar.get(1);
                int n16 = calendar.get(2);
                int n17 = calendar.get(5);
                int n18 = calendar.get(7);
                calendar.clear();
                calendar.set(n15, n16, 1);
                int n19 = calendar.get(7);
                int n20 = n = n18 < n19 ? 7 - (n19 - n18) : n18 - n19;
                if (n > 2) {
                    n -= 7;
                }
                calendar.set(n15, n16, n17 - n);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("IW")) {
                throw new ParseException("Not implimented");
            }
            if (string.equalsIgnoreCase("DAY") || string.equalsIgnoreCase("DY") || string.equalsIgnoreCase("D")) {
                if (date instanceof Time) {
                    throw new ParseException("Can't use TIME here");
                }
                int n = calendar.get(1);
                int n21 = calendar.get(2);
                int n22 = calendar.get(5);
                int n23 = calendar.get(7);
                int n24 = n23 - calendar.getFirstDayOfWeek();
                if (n24 > 2) {
                    n24 -= 7;
                }
                calendar.clear();
                calendar.set(n, n21, n22 - n24);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("HH") || string.equalsIgnoreCase("HH12") || string.equalsIgnoreCase("HH24")) {
                if (date instanceof java.sql.Date) {
                    throw new ParseException("Can't use DATE here");
                }
                int n = calendar.get(12);
                if (n >= 30) {
                    int n25 = calendar.get(11);
                    calendar.add(11, 1);
                }
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return new Timestamp(calendar.getTimeInMillis());
            }
            if (string.equalsIgnoreCase("MI")) {
                if (date instanceof java.sql.Date) {
                    throw new ParseException("Can't use DATE here");
                }
                int n = calendar.get(13);
                if (n >= 30) {
                    int n26 = calendar.get(12);
                    calendar.add(12, 1);
                }
                calendar.set(13, 0);
                calendar.set(14, 0);
                return new Timestamp(calendar.getTimeInMillis());
            }
            throw new ParseException("Unknown format");
        }
        throw new ParseException("Wrong type trunc(" + comparable.getClass() + "," + comparable2.getClass() + ")");
    }
}

