/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.math.BigDecimal;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.PostfixCommand;

public class Sign
extends PostfixCommand {
    public final int getNumberOfParameters() {
        return 1;
    }

    public void evaluate(ASTFunNode aSTFunNode, JepRuntime jepRuntime) throws ParseException {
        aSTFunNode.childrenAccept(jepRuntime.ev, null);
        Comparable comparable = jepRuntime.stack.pop();
        jepRuntime.stack.push(Sign.sign(comparable));
    }

    public static Integer sign(Comparable comparable) throws ParseException {
        if (comparable == null) {
            return null;
        }
        if (comparable instanceof String) {
            comparable = Sign.parse((String)((Object)comparable));
        }
        if (comparable instanceof BigDecimal) {
            return ((BigDecimal)comparable).signum();
        }
        if (comparable instanceof Double || comparable instanceof Float) {
            double d = ((Number)((Object)comparable)).doubleValue();
            return new Integer(d > 0.0 ? 1 : (d < 0.0 ? -1 : 0));
        }
        if (comparable instanceof Number) {
            long l = ((Number)((Object)comparable)).longValue();
            return new Integer(l > 0L ? 1 : (l < 0L ? -1 : 0));
        }
        throw new ParseException("Wrong type sign(" + comparable.getClass() + ")");
    }
}

