/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.OracleNumberFormat;
import org.medfoster.sqljep.function.OracleTimestampFormat;
import org.medfoster.sqljep.function.PostfixCommand;

public class ToChar
extends PostfixCommand {
    static final String PARAM_EXCEPTION = "Format should be string";
    static final String TYPE_EXCEPTION = "Unsupported type";

    public final int getNumberOfParameters() {
        return -1;
    }

    public void evaluate(ASTFunNode aSTFunNode, JepRuntime jepRuntime) throws ParseException {
        aSTFunNode.childrenAccept(jepRuntime.ev, null);
        int n = aSTFunNode.jjtGetNumChildren();
        if (n == 1) {
            Comparable comparable = jepRuntime.stack.pop();
            jepRuntime.stack.push((Comparable)((Object)ToChar.to_char(comparable)));
        } else if (n == 2) {
            Comparable comparable = jepRuntime.stack.pop();
            Comparable comparable2 = jepRuntime.stack.pop();
            jepRuntime.stack.push((Comparable)((Object)ToChar.to_char(comparable2, comparable, jepRuntime.calendar, jepRuntime.dateSymbols)));
        } else {
            this.removeParams(jepRuntime.stack, n);
            throw new ParseException("Wrong number of parameters for instr");
        }
    }

    public static String to_char(Comparable comparable) {
        String string = comparable == null ? null : (comparable instanceof BigDecimal ? ((BigDecimal)comparable).toPlainString() : comparable.toString());
        return string;
    }

    public static String to_char(Comparable comparable, Comparable comparable2, Calendar calendar, DateFormatSymbols dateFormatSymbols) throws ParseException {
        if (comparable == null || comparable2 == null) {
            return null;
        }
        if (comparable instanceof String && ((String)((Object)comparable)).length() == 0) {
            return null;
        }
        if (!(comparable2 instanceof String)) {
            throw new ParseException(PARAM_EXCEPTION);
        }
        if (comparable instanceof String) {
            return (String)((Object)comparable);
        }
        if (comparable instanceof Number) {
            try {
                OracleNumberFormat oracleNumberFormat = new OracleNumberFormat((String)((Object)comparable2));
                return oracleNumberFormat.format((Number)((Object)comparable));
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException(parseException.getMessage());
            }
        }
        if (comparable instanceof Date) {
            try {
                OracleTimestampFormat oracleTimestampFormat = new OracleTimestampFormat((String)((Object)comparable2), calendar, dateFormatSymbols);
                return oracleTimestampFormat.format((Timestamp)comparable);
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException(parseException.getMessage());
            }
        }
        throw new ParseException(TYPE_EXCEPTION);
    }
}

