/*
 * Decompiled with CFR 0.152.
 */
package org.medfoster.sqljep.function;

import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.OracleNumberFormat;
import org.medfoster.sqljep.function.PostfixCommand;

public class ToNumber
extends PostfixCommand {
    private static final String FORMAT_EXCEPTION = "Wrong number";
    private static final String TYPE_EXCEPTION = "Wrong type";

    public final int getNumberOfParameters() {
        return -1;
    }

    public void evaluate(ASTFunNode aSTFunNode, JepRuntime jepRuntime) throws ParseException {
        aSTFunNode.childrenAccept(jepRuntime.ev, null);
        int n = aSTFunNode.jjtGetNumChildren();
        if (n == 1) {
            Comparable comparable = jepRuntime.stack.pop();
            jepRuntime.stack.push(ToNumber.to_number(comparable));
        } else if (n == 2) {
            Comparable comparable = jepRuntime.stack.pop();
            Comparable comparable2 = jepRuntime.stack.pop();
            jepRuntime.stack.push(ToNumber.to_number(comparable2, comparable));
        } else {
            this.removeParams(jepRuntime.stack, n);
            throw new ParseException("Wrong number of parameters for instr");
        }
    }

    public static Comparable to_number(Comparable comparable) throws ParseException {
        if (comparable == null) {
            return null;
        }
        if (comparable instanceof String) {
            return ToNumber.parse((String)((Object)comparable));
        }
        if (comparable instanceof Number) {
            return comparable;
        }
        if (comparable instanceof Boolean) {
            return Integer.valueOf((Boolean)comparable != false ? 1 : 0);
        }
        throw new ParseException(FORMAT_EXCEPTION);
    }

    public static Comparable to_number(Comparable comparable, Comparable comparable2) throws ParseException {
        if (comparable == null || comparable2 == null) {
            return null;
        }
        if (comparable instanceof String && ((String)((Object)comparable)).length() == 0) {
            return null;
        }
        if (comparable instanceof Number) {
            return comparable;
        }
        if (!(comparable instanceof String) || !(comparable2 instanceof String)) {
            throw new ParseException("Wrong type  to_number(" + comparable.getClass() + "+" + comparable2.getClass() + ")");
        }
        StringBuilder stringBuilder = new StringBuilder((String)((Object)comparable));
        try {
            OracleNumberFormat oracleNumberFormat = new OracleNumberFormat((String)((Object)comparable2));
            return (Comparable)oracleNumberFormat.parseObject((String)((Object)comparable));
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage());
        }
    }
}

