/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.operation.perpendicular;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperation;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.primitive.Point;

public class Perpendicular
extends GeometryOperation {
    public static final String NAME = "perpendicular";
    private static GeometryManager geomManager = GeometryLocator.getGeometryManager();
    public static final int CODE = geomManager.getGeometryOperationCode("perpendicular");

    public Object invoke(Geometry geom, GeometryOperationContext ctx) throws GeometryOperationException {
        Point point1 = (Point)geom;
        Point point2 = (Point)ctx.getAttribute("secondPoint");
        Point perpendicularPoint = (Point)ctx.getAttribute("perpendicularPoint");
        if (point2.getY() - point1.getY() == 0.0) {
            try {
                return new Point[]{geomManager.createPoint(perpendicularPoint.getX(), 0.0, 0), geomManager.createPoint(perpendicularPoint.getX(), 1.0, 0)};
            }
            catch (CreateGeometryException e) {
                throw new GeometryOperationException((Exception)((Object)e));
            }
        }
        double m = (point1.getX() - point2.getX()) / (point2.getY() - point1.getY());
        double b = perpendicularPoint.getY() - m * perpendicularPoint.getX();
        try {
            return new Point[]{geomManager.createPoint(0.0, m * 0.0 + b, 0), geomManager.createPoint(1000.0, m * 1000.0 + b, 0)};
        }
        catch (CreateGeometryException e) {
            throw new GeometryOperationException((Exception)((Object)e));
        }
    }

    public int getOperationIndex() {
        return CODE;
    }
}

