/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.operation.perpendicular;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperation;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.operation.perpendicular.Perpendicular;
import org.gvsig.fmap.geom.operation.perpendicular.UnitVector;
import org.gvsig.fmap.geom.primitive.Point;

public class PerpendicularPoint
extends GeometryOperation {
    public static final String NAME = "perpendicularPoint";
    private static GeometryManager geomManager = GeometryLocator.getGeometryManager();
    public static final int CODE = geomManager.getGeometryOperationCode("perpendicularPoint");

    public Object invoke(Geometry geom, GeometryOperationContext ctx) throws GeometryOperationException {
        Point perpendicularPoint = (Point)ctx.getAttribute(NAME);
        double dist = (Double)ctx.getAttribute("distance");
        try {
            Point[] p = (Point[])geom.invokeOperation(Perpendicular.CODE, ctx);
            Point unit = (Point)geom.invokeOperation(UnitVector.CODE, ctx);
            return geomManager.createPoint(perpendicularPoint.getX() + unit.getX() * dist, perpendicularPoint.getY() + unit.getY() * dist, 0);
        }
        catch (GeometryOperationNotSupportedException e) {
            throw new GeometryOperationException((Exception)((Object)e));
        }
        catch (CreateGeometryException e) {
            throw new GeometryOperationException((Exception)((Object)e));
        }
    }

    public int getOperationIndex() {
        return CODE;
    }
}

