/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.operation.perpendicular;

import java.awt.geom.Point2D;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperation;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.primitive.Point;

public class UnitVector
extends GeometryOperation {
    public static final String NAME = "unitvector";
    private static GeometryManager geomManager = GeometryLocator.getGeometryManager();
    public static final int CODE = geomManager.getGeometryOperationCode("unitvector");

    public Object invoke(Geometry geom, GeometryOperationContext ctx) throws GeometryOperationException {
        Point point1 = (Point)geom;
        Point point2 = (Point)ctx.getAttribute("secondPoint");
        Point2D.Double paux = new Point2D.Double(point2.getX() - point1.getX(), point2.getY() - point1.getY());
        double v = Math.sqrt(Math.pow(((Point2D)paux).getX(), 2.0) + Math.pow(((Point2D)paux).getY(), 2.0));
        paux = new Point2D.Double(((Point2D)paux).getX() / v, ((Point2D)paux).getY() / v);
        try {
            return geomManager.createPoint(((Point2D)paux).getX() / v, ((Point2D)paux).getY() / v, 0);
        }
        catch (CreateGeometryException e) {
            throw new GeometryOperationException((Exception)((Object)e));
        }
    }

    public int getOperationIndex() {
        return CODE;
    }
}

