/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.operation.utils;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.operation.GeometryOperation;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.operation.distance.PointDistance;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.locator.LocatorException;

public class PointGetAngle
extends GeometryOperation {
    public static final String NAME = "getAngle";
    public static final int CODE = GeometryLocator.getGeometryManager().getGeometryOperationCode("getAngle");

    public int getOperationIndex() {
        return CODE;
    }

    public Object invoke(Geometry geom, GeometryOperationContext ctx) throws GeometryOperationException {
        double distance;
        Geometry geom2 = (Geometry)ctx.getAttribute("geom");
        GeometryType geomType2 = geom2.getGeometryType();
        if (1 != geom.getType() && 1 != geomType2.getType()) {
            throw new UnsupportedOperationException("The distance only can be execudet between two points");
        }
        Point start = (Point)geom;
        Point end = (Point)geom2;
        try {
            distance = (Double)GeometryLocator.getGeometryManager().invokeOperation(PointDistance.CODE, geom, ctx);
        }
        catch (GeometryOperationNotSupportedException | LocatorException e) {
            throw new GeometryOperationException((Exception)e);
        }
        double angle = Math.acos((end.getX() - start.getX()) / distance);
        if (start.getY() > end.getY()) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }
}

