/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.swing.scribejava.keycloak;

import javax.json.JsonObject;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderAuthenticationFactory;
import org.gvsig.downloader.spi.AbstractDownloaderAuthenticationConfig;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderAuthenticationKeycloakConfigPanel;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderAuthenticationKeycloakFactory;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderAuthenticationKeycloakRequester;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.util.LabeledValue;

public class DownloaderAuthenticationKeycloakConfig
extends AbstractDownloaderAuthenticationConfig
implements DownloaderAuthenticationConfig,
LabeledValue<DownloaderAuthenticationConfig> {
    private static final String DEFAULT_CLIENTID = "gvsigdesktop";
    private static final String DEFAULT_SCOPE = "openid";
    private static final int DEFAULT_LOCALPORT = 8888;
    private static final String PERSISTENT_DEFINITION_NAME = "UserIdentificationKeycloakConfig";
    private String clientid = "gvsigdesktop";
    private String realm = null;
    private String keycloakBaseurl = null;
    private int localPort = 8888;
    private String scope = "openid";

    public DownloaderAuthenticationKeycloakConfig(DownloaderAuthenticationKeycloakFactory factory, String serviceUrl) {
        super("Keycloak", (DownloaderAuthenticationFactory)factory, serviceUrl);
    }

    public DownloaderAuthenticationKeycloakConfig() {
        this(null, null);
    }

    public DownloaderAuthenticationKeycloakFactory getFactory() {
        return (DownloaderAuthenticationKeycloakFactory)super.getFactory();
    }

    public String getKey() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServiceUrl=").append(this.getServiceUrl()).append(";");
        builder.append("localport=").append(this.localPort).append(";");
        builder.append("clientid=").append(this.clientid).append(";");
        builder.append("scope=").append(this.scope).append(";");
        builder.append("realm=").append(this.realm).append(";");
        builder.append("baseurl=").append(this.keycloakBaseurl).append(";");
        return builder.toString();
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getKeycloakBaseurl() {
        return this.keycloakBaseurl;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getClientid() {
        return this.clientid;
    }

    public String getScope() {
        return this.scope;
    }

    public void setKeycloakBaseurl(String keycloakBaseurl) {
        this.keycloakBaseurl = keycloakBaseurl;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setClientid(String clientid) {
        this.clientid = clientid;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public DownloaderAuthenticationKeycloakRequester create() {
        if (StringUtils.isBlank((CharSequence)this.clientid)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.realm)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)this.keycloakBaseurl)) {
            return null;
        }
        if (this.localPort < 1024) {
            return null;
        }
        return new DownloaderAuthenticationKeycloakRequester(this);
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isFilled() {
        return StringUtils.isNotBlank((CharSequence)this.clientid) && StringUtils.isNotBlank((CharSequence)this.scope) && this.localPort >= 1024 && StringUtils.isNotBlank((CharSequence)this.realm) && StringUtils.isNotBlank((CharSequence)this.keycloakBaseurl);
    }

    public boolean requestAuthenticationConfig() {
        WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        DownloaderAuthenticationKeycloakConfigPanel panel = new DownloaderAuthenticationKeycloakConfigPanel();
        panel.put(this);
        Dialog dialog = winmgr.createDialog((JComponent)panel, "Configuracion de Keycloak", null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                panel.fetch(this);
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
        return dialog.getAction() == 1;
    }

    public void fromJson(JsonObject json) {
        String type = json.getString("type", null);
        if (type != null) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)"OAuth")) {
                throw new IllegalArgumentException("Invalid value of type '" + type + "' for '" + "Keycloak" + "'.");
            }
            this.realm = json.getString("realm", null);
            this.keycloakBaseurl = json.getString("url", null);
            if (StringUtils.isNotBlank((CharSequence)this.keycloakBaseurl)) {
                this.keycloakBaseurl = this.keycloakBaseurl.endsWith("/") ? this.keycloakBaseurl + "realms" : this.keycloakBaseurl + "/realms";
            }
        } else {
            super.fromJson(json);
            this.clientid = json.getString("clientid", null);
            this.scope = json.getString("scope", null);
            this.realm = json.getString("realm", null);
            this.keycloakBaseurl = json.getString("baseurl", null);
            this.localPort = json.getInt("localPort", 0);
        }
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = super.toJsonBuilder();
        builder.add_class((Object)this);
        builder.add("clientid", this.clientid);
        builder.add("scope", this.scope);
        builder.add("realm", this.realm);
        builder.add("baseurl", this.keycloakBaseurl);
        builder.add("localPort", this.localPort);
        return builder;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("clientid", this.clientid);
        state.set("scope", this.scope);
        state.set("baseurl", this.keycloakBaseurl);
        state.set("realm", this.realm);
        state.set("localPort", this.localPort);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.clientid = state.getString("clientid");
        this.scope = state.getString("scope");
        this.keycloakBaseurl = state.getString("baseurl");
        this.realm = state.getString("realm");
        this.localPort = state.getInt("localPort");
    }

    public static void selfRegister() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENT_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(DownloaderAuthenticationKeycloakConfig.class, PERSISTENT_DEFINITION_NAME, "DownloaderAuthenticationKeycloakConfig persistence definition", null, null);
            definition.extend("Persistence", "DownloaderAuthenticationConfig");
            definition.addDynFieldString("clientid");
            definition.addDynFieldString("scope");
            definition.addDynFieldString("baseurl");
            definition.addDynFieldString("realm");
            definition.addDynFieldInt("localPort");
        }
        Json.registerSerializer(DownloaderAuthenticationKeycloakConfig.class);
    }

    public String getLabel() {
        return String.format("%s - %s", this.keycloakBaseurl, this.realm);
    }

    public DownloaderAuthenticationKeycloakConfig getValue() {
        return this;
    }

    public String toString() {
        return String.format("Factory: %s\nKeycloak URL:%s\nRealm: %s\nLocal port:%d", this.getFactory().getProviderName(), this.getKeycloakBaseurl(), this.getRealm(), this.getLocalPort());
    }

    public DownloaderAuthenticationConfig createAuthenticationConfig(String serviceUrl) {
        if (StringUtils.isBlank((CharSequence)serviceUrl)) {
            return null;
        }
        DownloaderAuthenticationKeycloakConfig other = new DownloaderAuthenticationKeycloakConfig(null, serviceUrl);
        other.clientid = this.clientid;
        other.keycloakBaseurl = this.keycloakBaseurl;
        other.localPort = this.localPort;
        other.realm = this.realm;
        other.scope = this.scope;
        return other;
    }
}

