/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.swing.scribejava.keycloak;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.gvsig.downloader.DownloaderAuthenticationFactory;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.spi.AbstractDownloaderAuthenticationFactory;
import org.gvsig.downloader.swing.scribejava.keycloak.DownloaderAuthenticationKeycloakConfig;

public class DownloaderAuthenticationKeycloakFactory
extends AbstractDownloaderAuthenticationFactory
implements DownloaderAuthenticationFactory {
    public static final String AUTH_MODE_KEYCLOAK = "Keycloak";
    private HttpServer httpserver;

    public DownloaderAuthenticationKeycloakFactory() {
        super(AUTH_MODE_KEYCLOAK);
    }

    public DownloaderAuthenticationKeycloakConfig create(Object ... parameters) {
        return new DownloaderAuthenticationKeycloakConfig(this, (String)parameters[0]);
    }

    public HttpServer getHttpServer(DownloaderAuthenticationKeycloakConfig config) throws IOException {
        if (this.httpserver == null) {
            this.httpserver = HttpServer.create(new InetSocketAddress(config.getLocalPort()), 0);
            this.httpserver.setExecutor(null);
            this.httpserver.start();
        }
        return this.httpserver;
    }

    public void stopHttpServer(int delay) {
        if (this.httpserver != null) {
            this.httpserver.stop(0);
        }
    }

    public void addCallback(DownloaderAuthenticationKeycloakConfig config, String contextPath, HttpHandler handler) throws IOException {
        this.getHttpServer(config).createContext(contextPath, handler);
    }

    public void removeCallback(DownloaderAuthenticationKeycloakConfig config, String contextPath) throws IOException {
        this.getHttpServer(config).removeContext(contextPath);
    }

    public static void selfRegister() {
        DownloaderAuthenticationKeycloakConfig.selfRegister();
        DownloaderManager manager = DownloaderLocator.getDownloaderManager();
        manager.registerAuthenticationType((DownloaderAuthenticationFactory)new DownloaderAuthenticationKeycloakFactory());
    }

    public String getDescription() {
        return "Authentication using OpenId Connect with Keycloak";
    }
}

