/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.serverexplorer.db.spi;

import java.util.List;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.serverexplorer.db.DBServerExplorer;
import org.gvsig.fmap.dal.spi.AbstractDataServerExplorer;
import org.gvsig.fmap.dal.spi.DataServerExplorerProvider;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;

public abstract class AbstractDBServerExplorer
extends AbstractDataServerExplorer
implements DBServerExplorer,
DataServerExplorerProvider {
    protected AbstractDBServerExplorer(DataServerExplorerParameters parameters, DataServerExplorerProviderServices services) {
        super(parameters, services);
    }

    public abstract String getStoreName();

    public boolean canAdd(String storeName) throws DataException {
        return this.getStoreName().equals(storeName);
    }

    public NewDataStoreParameters getAddParameters(String storeName) throws DataException {
        if (!this.getStoreName().equals(storeName)) {
            throw new IllegalArgumentException();
        }
        return this.getAddParameters();
    }

    public List list() throws DataException {
        return this.list(0);
    }

    public DataStore open(DataStoreParameters dsp) throws DataException {
        DataManager dataMan = DALLocator.getDataManager();
        try {
            DataStore store = dataMan.openStore(dsp.getProviderName(), dsp);
            return store;
        }
        catch (ValidateDataParametersException e) {
            throw new InitializeException((Throwable)e);
        }
    }
}

