/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.japura.Application;
import org.japura.controller.ChildController;
import org.japura.controller.Controller;
import org.japura.controller.ControllerException;
import org.japura.controller.ControllerModel;
import org.japura.controller.Group;
import org.japura.controller.InvalidControllerClassException;
import org.japura.controller.Lock;
import org.japura.controller.Message;
import org.japura.controller.MessageFilter;
import org.japura.controller.Singleton;
import org.japura.task.Task;
import org.japura.task.TaskSequence;
import org.japura.task.TaskSession;

public abstract class AbstractController
implements ControllerModel {
    static AbstractController newParentController;
    private AbstractController parentController;
    private List<ControllerModel> childrenControllers;
    private List<MessageFilter> filters;
    private String id;
    private Group group;
    private boolean permanent;
    private boolean removed;
    private String controllerName;
    private String modalGroupName;
    private long creationDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractController() {
        Lock.lock();
        try {
            if (this.getClass().isAnnotationPresent(ChildController.class) && newParentController == null) {
                throw new ControllerException("[" + this.getClass().getName() + "] Child controller must be instantiated through method createChild");
            }
            Class<?> cl = this.getClass();
            if (cl.isAnnotationPresent(Singleton.class) && Controller.count(cl) > 0) {
                throw new ControllerException("[" + cl.getName() + "] Singleton Controller");
            }
            this.parentController = newParentController;
            this.childrenControllers = new ArrayList<ControllerModel>();
            this.filters = new ArrayList<MessageFilter>();
            this.id = Application.buildId();
            this.creationDate = System.currentTimeMillis();
            if (this.parentController != null) {
                Group group;
                this.group = group = this.parentController.getGroup();
                this.parentController.addChild(this);
            } else {
                Group group;
                this.group = group = new Group(this.getControllerId());
            }
            Controller.add(this);
            Controller.updateDebugComponents();
        }
        finally {
            newParentController = null;
            Lock.unlock();
        }
    }

    @Override
    public String stringToDebugComponent() {
        if (this.getControllerName() != null) {
            return "Id:" + this.getControllerId() + " - Name: " + this.getControllerName();
        }
        return "Id:" + this.getControllerId();
    }

    protected void testControllerModel(Class<?> clss) {
        if (!ControllerModel.class.isAssignableFrom(clss)) {
            throw new InvalidControllerClassException(clss);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <E> E createChild(Class<E> clss) {
        Lock.lock();
        try {
            this.testControllerModel(clss);
            if (!Controller.contains(this)) {
                throw new ControllerException("The controller " + this.getClass() + " id (" + this.getControllerId() + ") already had been removed from the pool. ");
            }
            newParentController = this;
            E e = Controller.newInstance(clss);
            return e;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> List<E> getChildren(Class<E> clss) {
        Lock.lock();
        try {
            ArrayList<E> list = new ArrayList<E>();
            for (ControllerModel controller : this.childrenControllers) {
                if (!clss.isAssignableFrom(controller.getClass())) continue;
                list.add(clss.cast(controller));
            }
            ArrayList<E> arrayList = list;
            return arrayList;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChildInstancied(Class<?> clss) {
        Lock.lock();
        try {
            for (ControllerModel controller : this.childrenControllers) {
                if (!clss.isAssignableFrom(controller.getClass())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ControllerModel> getChildren() {
        Lock.lock();
        try {
            List<ControllerModel> list = Collections.unmodifiableList(this.childrenControllers);
            return list;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E getChild(Class<E> clss) {
        Lock.lock();
        try {
            for (ControllerModel controller : this.childrenControllers) {
                if (!clss.isAssignableFrom(controller.getClass())) continue;
                E e = clss.cast(controller);
                return e;
            }
            E e = null;
            return e;
        }
        finally {
            Lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ControllerModel getChild(String id) {
        Lock.lock();
        try {
            if (id != null) {
                for (ControllerModel controller : this.childrenControllers) {
                    if (!controller.getControllerId().equals(id)) continue;
                    ControllerModel controllerModel = controller;
                    return controllerModel;
                }
            }
            ControllerModel controllerModel = null;
            return controllerModel;
        }
        finally {
            Lock.unlock();
        }
    }

    void addChild(ControllerModel controller) {
        this.childrenControllers.add(controller);
    }

    void removeChild(ControllerModel controller) {
        this.childrenControllers.remove(controller);
    }

    @Override
    public final String getControllerId() {
        return this.id;
    }

    @Override
    public final Group getGroup() {
        return this.group;
    }

    @Override
    public final boolean isPermanent() {
        return this.permanent;
    }

    @Override
    public final String getGroupId() {
        return this.getGroup().getId();
    }

    @Override
    public String getModalGroupName() {
        return this.modalGroupName;
    }

    @Override
    public void setModalGroupName(String modalGroupName) {
        this.modalGroupName = modalGroupName;
    }

    @Override
    public String getControllerName() {
        return this.controllerName;
    }

    public void setControllerName(String controllerName) {
        this.controllerName = controllerName;
    }

    @Override
    public final String getParentId() {
        if (this.getParent() != null) {
            return this.getParent().getControllerId();
        }
        return null;
    }

    protected final void setPermanent(boolean permanent) {
        this.permanent = permanent;
    }

    protected <E> E getFromLink(Class<E> clss) {
        return Controller.getFromLink(this, clss);
    }

    protected void linkTo(ControllerModel controller) {
        Controller.link(this, controller);
    }

    protected boolean hasLinkTo(Class<?> clss) {
        return Controller.existsLink((ControllerModel)this, clss);
    }

    protected boolean hasLinkTo(ControllerModel controller) {
        return Controller.existsLink((ControllerModel)this, controller);
    }

    protected void unlink() {
        Controller.unlink(this);
    }

    @Override
    public void free() {
        Controller.free(this.getControllerId(), true);
    }

    @Override
    public void free(boolean cancelTaskExecution) {
        Controller.free(this.getControllerId(), cancelTaskExecution);
    }

    @Override
    public void freeGroup() {
        Controller.freeGroup(this.getGroupId());
    }

    @Override
    public final boolean isRemoved() {
        return this.removed;
    }

    @Override
    public final ControllerModel getParent() {
        return this.parentController;
    }

    void clearParent() {
        this.parentController = null;
    }

    void setAsRemoved() {
        this.removed = true;
    }

    void clearChildren() {
        this.childrenControllers.clear();
    }

    @Override
    public final boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public final ControllerModel getRoot() {
        ControllerModel superController = this;
        while (superController.getParent() != null) {
            superController = superController.getParent();
        }
        return superController;
    }

    protected boolean canSubmit(Task<?> task) {
        return true;
    }

    @Override
    public List<MessageFilter> getMessageFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    protected void removeMessageFilters() {
        this.filters.clear();
    }

    protected void removeMessageFilter(MessageFilter filter) {
        if (filter != null) {
            this.filters.remove(filter);
        }
    }

    protected boolean containsMessageFilter(MessageFilter filter) {
        if (filter != null) {
            return this.filters.contains(filter);
        }
        return false;
    }

    protected void addMessageFilter(MessageFilter filter) {
        if (filter != null && !this.filters.contains(filter)) {
            this.filters.add(filter);
        }
    }

    @Override
    public final void publish(Message message) {
        message.setPublisher(this);
        Controller.publishToAll(message);
    }

    @Override
    public void subscribe(Message message) {
    }

    protected void beforeFreeController() {
    }

    protected void afterFreeController() {
    }

    @Override
    public void submit(Task<?> task) {
        this.submit(task, null, false);
    }

    @Override
    public void submit(Task<?> task, TaskSession session) {
        this.submit(task, session, false);
    }

    @Override
    public void submit(Task<?> task, boolean isParallel) {
        this.submit(task, null, isParallel);
    }

    @Override
    public void submit(TaskSequence taskSequence) {
        if (taskSequence.hasTask()) {
            this.submit(taskSequence.getFirstTask(), null, false);
        }
    }

    @Override
    public void submit(TaskSequence taskSequence, TaskSession session) {
        if (taskSequence.hasTask()) {
            this.submit(taskSequence.getFirstTask(), session, false);
        }
    }

    @Override
    public void submit(Task<?> task, TaskSession session, boolean isParallel) {
        if (!Controller.contains(this)) {
            throw new ControllerException("Controller is not in the pool");
        }
        if (!this.canSubmit(task)) {
            return;
        }
        task.setRootModel(this.getRoot());
        Application.getTaskManager().submit(task, session, isParallel);
    }

    @Override
    public long getCreationDate() {
        return this.creationDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractController other = (AbstractController)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

