/*
 * Decompiled with CFR 0.152.
 */
package org.japura.controller.modals;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.japura.gui.WrapLabel;
import org.japura.modal.Modal;

public abstract class AbstractPanel
extends JPanel {
    private static final long serialVersionUID = 6038019098837978157L;
    private WrapLabel titleLabel;
    private WrapLabel label;
    private int width = 300;
    private String text;
    private String title;

    public AbstractPanel(String title, String text) {
        this(title, text, null);
    }

    public AbstractPanel(String title, String text, Icon icon) {
        if (icon == null) {
            icon = this.getIcon();
        }
        this.title = title;
        this.text = text != null ? text : "";
        this.setName("modalPanel");
        Border out = BorderFactory.createLineBorder(Color.BLACK, 2);
        Border in = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        this.setBorder(BorderFactory.createCompoundBorder(out, in));
        this.setBackground(Color.WHITE);
        this.setLayout(new BorderLayout(0, 5));
        if (title != null && title.length() > 0) {
            this.add((Component)this.getTitleLabel(), "North");
        }
        this.add((Component)this.getButtonsPanel(), "South");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.weighty = 1.0;
        if (icon != null) {
            panel.add((Component)new JLabel(icon), gbc);
        }
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        panel.add((Component)this.getLabel(), gbc);
        JComponent content = this.getContent();
        if (content != null) {
            gbc.gridx = 0;
            gbc.gridy = 1;
            if (icon != null) {
                gbc.gridwidth = 2;
            }
            panel.add((Component)content, gbc);
        }
        this.add((Component)panel, "Center");
    }

    protected abstract JPanel getButtonsPanel();

    @Deprecated
    protected Icon getIcon() {
        return null;
    }

    protected abstract JComponent getContent();

    private WrapLabel getTitleLabel() {
        if (this.titleLabel == null) {
            this.titleLabel = new WrapLabel();
            this.titleLabel.setName("titleLabel");
            if (this.title != null) {
                this.titleLabel.setText(this.title);
            }
            this.titleLabel.setWrapWidth(this.width);
            this.titleLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
        }
        return this.titleLabel;
    }

    private WrapLabel getLabel() {
        if (this.label == null) {
            this.label = new WrapLabel(this.text);
            this.label.setWrapWidth(this.width);
            this.label.setName("messageLabel");
        }
        return this.label;
    }

    protected final void setTextWrapWidth(int value) {
        this.width = value;
    }

    protected final int getTextWrapWidth() {
        return this.width;
    }

    public final void closeModal() {
        Modal.closeModal(this);
    }
}

