/*
 * Decompiled with CFR 0.152.
 */
package org.japura.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ContentPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ButtonPanel buttonsPanel;
    private Color buttonBackground = new Color(215, 215, 215);
    private JLabel iconLabel;
    private LinkedHashMap<Component, Integer> contents;
    private int defaultGap = 7;
    private int margin = 7;

    public ContentPanel() {
        this.setBackground(new Color(245, 245, 245));
        this.contents = new LinkedHashMap();
        this.buttonsPanel = new ButtonPanel();
        this.buttonsPanel.setLayout(new FlowLayout(2));
        super.add(this.buttonsPanel);
    }

    public final JPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    public void setIcon(Icon icon) {
        if (icon != null) {
            if (this.iconLabel == null) {
                this.iconLabel = new JLabel();
                super.add(this.iconLabel);
            }
            this.iconLabel.setIcon(icon);
        } else if (this.iconLabel != null) {
            super.remove(this.iconLabel);
        }
    }

    public void addContent(Component content) {
        this.addContent(content, this.defaultGap);
    }

    public void addContent(Component content, int topMargin) {
        super.add(content);
        this.contents.put(content, Math.max(topMargin, 0));
    }

    public void removeContent(Component content) {
        super.remove(content);
        this.contents.remove(content);
    }

    @Override
    public Component add(Component comp) {
        this.addContent(comp);
        return comp;
    }

    @Override
    public Component add(Component comp, int index) {
        this.addContent(comp);
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.addContent(comp);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.addContent(comp);
    }

    @Override
    public void remove(Component comp) {
        this.removeContent(comp);
    }

    @Override
    public void remove(int index) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    public final void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        int x = this.margin;
        int y = this.margin;
        if (this.iconLabel != null) {
            Dimension iconDim = this.iconLabel.getPreferredSize();
            this.iconLabel.setBounds(x, y, iconDim.width, iconDim.height);
            x += iconDim.width + this.defaultGap;
            width -= iconDim.width + this.defaultGap;
        }
        if (this.buttonsPanel.isVisible()) {
            Dimension bpDim = this.buttonsPanel.getPreferredSize();
            this.buttonsPanel.setBounds(0, height - bpDim.height, this.getWidth(), bpDim.height);
            height -= bpDim.height;
        }
        height -= this.margin;
        width -= 2 * this.margin;
        for (Component content : this.contents.keySet()) {
            content.setBounds(0, 0, 0, 0);
        }
        boolean first = true;
        for (Map.Entry<Component, Integer> entry : this.contents.entrySet()) {
            Component content = entry.getKey();
            int gap = entry.getValue();
            Dimension dim = content.getPreferredSize();
            if (y > height + gap) break;
            if (!first) {
                y += gap;
            }
            int limitHeight = height - y;
            content.setBounds(x, y, width, Math.min(dim.height, limitHeight));
            y += dim.height;
            first = false;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dim = new Dimension(2 * this.margin, 2 * this.margin);
        int max = 0;
        boolean first = true;
        for (Map.Entry<Component, Integer> entry : this.contents.entrySet()) {
            Component content = entry.getKey();
            int gap = entry.getValue();
            Dimension contentDim = content.getPreferredSize();
            max = Math.max(max, contentDim.width);
            dim.height += contentDim.height;
            if (!first) {
                dim.height += gap;
            }
            first = false;
        }
        dim.width += max;
        if (this.iconLabel != null) {
            Dimension iconDim = this.iconLabel.getPreferredSize();
            dim.height = Math.max(dim.height, iconDim.height);
            dim.width += this.defaultGap + iconDim.width;
        }
        if (this.buttonsPanel.isVisible()) {
            Dimension bpDim = this.buttonsPanel.getPreferredSize();
            dim.width = Math.max(dim.width, bpDim.width);
            dim.height += bpDim.height;
        }
        return dim;
    }

    private class ButtonPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private ButtonPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(new GradientPaint(new Point2D.Double(0.0, 0.0), ContentPanel.this.getBackground(), new Point2D.Double(this.getWidth(), 0.0), ContentPanel.this.buttonBackground));
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.setPaint(new GradientPaint(new Point2D.Double(this.getWidth(), 0.0), Color.gray, new Point2D.Double(0.0, 0.0), ContentPanel.this.getBackground()));
                g2d.fillRect(0, 0, this.getWidth(), 1);
            }
        }
    }
}

