/*
 * Decompiled with CFR 0.152.
 */
package org.japura.dialogs;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.japura.dialogs.DefaultMessageDialog;

public class MessageDialogButton {
    private String buttonText;
    private ResultProvider resultProvider;
    private JButton button;

    public MessageDialogButton(String buttonText) {
        this.buttonText = buttonText;
    }

    public MessageDialogButton(String buttonText, ResultProvider resultProvider) {
        this(buttonText);
        this.resultProvider = resultProvider;
    }

    public MessageDialogButton(String buttonText, Object result) {
        this(buttonText);
        this.resultProvider = new UserResultProvider(result);
    }

    public MessageDialogButton(String buttonText, JTextComponent textComponent, boolean required, boolean applyTrim) {
        this(buttonText);
        this.resultProvider = new TextComponentResultProvider(textComponent, applyTrim);
        if (required) {
            textComponent.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ((TextComponentResultProvider)MessageDialogButton.this.resultProvider).update(MessageDialogButton.this.getButton());
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ((TextComponentResultProvider)MessageDialogButton.this.resultProvider).update(MessageDialogButton.this.getButton());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ((TextComponentResultProvider)MessageDialogButton.this.resultProvider).update(MessageDialogButton.this.getButton());
                }
            });
            ((TextComponentResultProvider)this.resultProvider).update(this.getButton());
        }
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public Object getResult() {
        if (this.resultProvider != null) {
            return this.resultProvider.getResult();
        }
        return null;
    }

    public JButton getButton() {
        if (this.button == null) {
            this.button = new JButton(this.getButtonText());
        }
        return this.button;
    }

    public void initializeButton(final DefaultMessageDialog dialog) {
        this.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setResult(MessageDialogButton.this.getResult());
                dialog.dispose();
            }
        });
    }

    public static interface ResultProvider {
        public Object getResult();
    }

    private static class UserResultProvider
    implements ResultProvider {
        private Object result;

        public UserResultProvider(Object result) {
            this.result = result;
        }

        @Override
        public Object getResult() {
            return this.result;
        }
    }

    private static class TextComponentResultProvider
    implements ResultProvider {
        private JTextComponent component;
        private boolean applyTrim;

        private TextComponentResultProvider(JTextComponent component, boolean applyTrim) {
            this.applyTrim = applyTrim;
            this.component = component;
        }

        @Override
        public Object getResult() {
            String text = this.component.getText();
            if (this.applyTrim) {
                text = text.trim();
            }
            return text;
        }

        public void update(JButton button) {
            boolean enabled = true;
            String text = (String)this.getResult();
            if (text.length() == 0) {
                enabled = false;
            }
            button.setEnabled(enabled);
        }
    }
}

