/*
 * Decompiled with CFR 0.152.
 */
package org.japura.exception;

import java.util.HashMap;
import org.japura.exception.HandlerException;
import org.japura.exception.HandlerExceptionManager;

public final class DefaultHandlerExceptionManager
implements HandlerExceptionManager {
    private static HashMap<String, HandlerException> handlers = new HashMap();

    @Override
    public void register(Class<? extends Throwable> throwableClass, HandlerException handler) {
        if (throwableClass != null && handler != null) {
            handlers.put(throwableClass.getName(), handler);
        }
    }

    @Override
    public void handle(Throwable throwable) {
        this.handle(throwable, new HashMap<String, Object>());
    }

    @Override
    public void handle(Throwable throwable, HashMap<String, Object> parameters) {
        if (handlers.size() == 0) {
            this.register(Exception.class, new HandlerException(){

                @Override
                public void handle(Throwable throwable, HashMap<String, Object> parameters) {
                    throwable.printStackTrace();
                }
            });
        }
        if (throwable != null) {
            for (Class<?> throwableClass = throwable.getClass(); throwableClass != null; throwableClass = throwableClass.getSuperclass()) {
                if (!handlers.containsKey(throwableClass.getName())) continue;
                HandlerException handler = handlers.get(throwableClass.getName());
                if (parameters == null) {
                    parameters = new HashMap();
                }
                handler.handle(throwable, parameters);
                return;
            }
        }
    }
}

