/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import org.japura.gui.Anchor;
import org.japura.gui.EmbeddedComponent;
import org.japura.gui.WrapperComponent;

public abstract class AbstractComboBox
extends JComponent {
    private static final long serialVersionUID = 5685295148232238680L;
    private Popup popup;
    private EmbeddedComponent embeddedComponent;
    private long lastViewChanged;
    private WrapperComponent wrapperComponent;
    private JComboBox comboBox;
    private String prototypeDisplayValue;

    public AbstractComboBox() {
        this.setFocusable(true);
        super.setLayout(new BorderLayout());
        this.add((Component)this.getWrapperComponent(), "Center");
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AbstractComboBox.this.getComboBox().requestFocusInWindow();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                AbstractComboBox.this.setPopupVisible(false);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                AbstractComboBox.this.setPopupVisible(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                if (event.getSource() != AbstractComboBox.this) {
                    AbstractComboBox.this.setPopupVisible(false);
                }
            }
        });
    }

    protected abstract JComponent getPopupComponent();

    protected final JComboBox getComboBox() {
        if (this.comboBox == null) {
            this.comboBox = new ComboBox();
        }
        return this.comboBox;
    }

    @Override
    public void setBackground(Color bg) {
        this.getComboBox().setBackground(bg);
    }

    @Override
    public void setForeground(Color fg) {
        this.getComboBox().setForeground(fg);
    }

    @Override
    public Color getForeground() {
        return this.getComboBox().getForeground();
    }

    @Override
    public Color getBackground() {
        return this.getComboBox().getBackground();
    }

    private WrapperComponent getWrapperComponent() {
        if (this.wrapperComponent == null) {
            MouseAdapter listener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    long time = Math.abs(AbstractComboBox.this.lastViewChanged - e.getWhen());
                    if (time > 20L) {
                        AbstractComboBox.this.changePopupVisible();
                    }
                }
            };
            this.wrapperComponent = new WrapperComponent(this.getComboBox(), listener);
        }
        return this.wrapperComponent;
    }

    public EmbeddedComponent removeEmbeddedComponent() {
        EmbeddedComponent ret = this.embeddedComponent;
        this.unregisterEmbeddedComponent(ret.getComponent());
        this.embeddedComponent = null;
        return ret;
    }

    protected abstract void unregisterEmbeddedComponent(JComponent var1);

    protected abstract void registerEmbeddedComponent(JComponent var1);

    public void setEmbeddedComponent(EmbeddedComponent embeddedComponent) {
        JComponent comp;
        if (this.embeddedComponent != null) {
            comp = embeddedComponent.getComponent();
            this.unregisterEmbeddedComponent(comp);
        }
        this.embeddedComponent = embeddedComponent;
        comp = embeddedComponent.getComponent();
        this.registerEmbeddedComponent(comp);
    }

    public EmbeddedComponent getEmbeddedComponent() {
        return this.embeddedComponent;
    }

    private void changePopupVisible() {
        this.setPopupVisible(!this.isPopupVisible());
    }

    public boolean isPopupVisible() {
        return this.getPopup().isVisible();
    }

    public abstract void setPopupVisible(boolean var1);

    public void setPrototypeDisplayValue(String prototypeDisplayValue) {
        this.prototypeDisplayValue = prototypeDisplayValue;
    }

    public String getPrototypeDisplayValue() {
        return this.prototypeDisplayValue;
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
    }

    protected abstract void updateComboBox();

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getWrapperComponent().setEnabled(enabled);
    }

    protected final Popup getPopup() {
        if (this.popup == null) {
            this.popup = new Popup();
            this.popup.setLayout(new BorderLayout());
            this.popup.setBorder(BorderFactory.createEmptyBorder());
            this.popup.add(this.getPopupComponent());
            if (this.getEmbeddedComponent() != null) {
                Anchor anchor = this.getEmbeddedComponent().getAnchor();
                if (anchor == null) {
                    throw new IllegalArgumentException("Null Anchor");
                }
                JPanel embeddedPanel = new JPanel();
                embeddedPanel.setLayout(new BorderLayout());
                JComponent comp = this.getEmbeddedComponent().getComponent();
                embeddedPanel.add(comp);
                if (anchor.equals((Object)Anchor.NORTH)) {
                    this.popup.add((Component)embeddedPanel, "North");
                    embeddedPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, Color.black));
                } else if (anchor.equals((Object)Anchor.SOUTH)) {
                    this.popup.add((Component)embeddedPanel, "South");
                    embeddedPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, Color.black));
                } else {
                    throw new IllegalArgumentException("Illegal anchor. Must be NORTH or SOUTH");
                }
            }
            this.popup.addMenuKeyListener(new MenuKeyListener(){

                @Override
                public void menuKeyTyped(MenuKeyEvent e) {
                }

                @Override
                public void menuKeyReleased(MenuKeyEvent e) {
                }

                @Override
                public void menuKeyPressed(MenuKeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        AbstractComboBox.this.setPopupVisible(false);
                    } else if (e.getKeyCode() == 9) {
                        AbstractComboBox.this.setPopupVisible(false);
                        if (e.getModifiersEx() == 64) {
                            AbstractComboBox.this.transferFocusBackward();
                        } else {
                            AbstractComboBox.this.transferFocus();
                        }
                    }
                }
            });
        }
        return this.popup;
    }

    protected class Popup
    extends JPopupMenu {
        private static final long serialVersionUID = -7940039384534412109L;

        public Popup() {
            for (MenuKeyListener l : this.getMenuKeyListeners()) {
                this.removeMenuKeyListener(l);
            }
        }

        @Override
        public void setVisible(boolean b) {
            AbstractComboBox.this.lastViewChanged = System.currentTimeMillis();
            super.setVisible(b);
            if (!b) {
                AbstractComboBox.this.popup = null;
            }
        }
    }

    private class ComboBox
    extends JComboBox {
        private static final long serialVersionUID = 10000012219553L;

        private ComboBox() {
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 40) {
                AbstractComboBox.this.setPopupVisible(true);
            }
        }
    }
}

