/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.japura.gui.Images;

public class LinkLabel
extends JLabel {
    private static final long serialVersionUID = -260221785668861855L;
    private Cursor mouseOverCursor;

    public LinkLabel() {
        ImageIcon ii = new ImageIcon(Images.LINK_HAND);
        this.mouseOverCursor = Toolkit.getDefaultToolkit().createCustomCursor(ii.getImage(), new Point(12, 6), "linkHand");
        this.putClientProperty("html.disable", Boolean.TRUE);
        this.setForeground(Color.BLUE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LinkLabel.this.doClick();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkLabel.this.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkLabel.this.setCursor(LinkLabel.this.mouseOverCursor);
            }
        });
    }

    public void doClick() {
        if (this.isEnabled()) {
            this.fireActionPerformed();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        Insets insets = this.getInsets();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String text = this.getText();
        if (text.length() > 0) {
            if (this.isEnabled()) {
                g2d.setColor(this.getForeground());
            } else {
                Color color = UIManager.getColor("Label.disabledForeground");
                if (color == null) {
                    color = Color.LIGHT_GRAY;
                }
                g2d.setColor(color);
            }
            int x = insets.left;
            Icon icon = this.getIcon();
            AttributedString as = new AttributedString(text);
            as.addAttribute(TextAttribute.FONT, this.getFont());
            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, 0, text.length());
            FontMetrics fm = this.getFontMetrics(this.getFont());
            if (this.getVerticalTextPosition() == 0) {
                if (icon != null) {
                    int y = (this.getHeight() - icon.getIconHeight()) / 2;
                    y = Math.max(0, y);
                    icon.paintIcon(this, g2d, x, y);
                    x += icon.getIconWidth() + this.getIconTextGap();
                }
                int v = (this.getHeight() - (insets.bottom + insets.top + fm.getHeight())) / 2;
                g2d.drawString(as.getIterator(), x, insets.top + fm.getAscent() + fm.getLeading() + v);
            } else if (this.getVerticalTextPosition() == 1) {
                if (icon != null) {
                    icon.paintIcon(this, g2d, x, insets.top);
                    x += icon.getIconWidth() + this.getIconTextGap();
                }
                g2d.drawString(as.getIterator(), x, insets.top + fm.getAscent() + fm.getLeading());
            } else if (this.getVerticalTextPosition() == 3) {
                if (icon != null) {
                    icon.paintIcon(this, g2d, x, this.getHeight() - (insets.bottom + icon.getIconHeight()));
                    x += icon.getIconWidth() + this.getIconTextGap();
                }
                g2d.drawString(as.getIterator(), x, this.getHeight() - (insets.bottom + fm.getDescent()));
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        if (listener != null) {
            this.listenerList.add(ActionListener.class, listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (listener != null) {
            this.listenerList.remove(ActionListener.class, listener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed() {
        ActionListener[] listeners;
        ActionEvent event = new ActionEvent(this, 1001, "linkClicked", System.currentTimeMillis(), 0);
        for (ActionListener listener : listeners = (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            listener.actionPerformed(event);
        }
    }
}

