/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.japura.gui.Gradient;
import org.japura.gui.PaintedPanel;

public class TitlePanel
extends JComponent {
    private static final long serialVersionUID = -2767246232683839619L;
    private static Object defaultTitleBackground = new Gradient(Gradient.TOP_TO_BOTTOM, new Color(160, 190, 255), new Color(240, 240, 255));
    private int borderY;
    private int titleSeparatorY;
    private PaintedPanel paintedPanel;
    private JLabel titleIcon;
    private JLabel titleLabel;
    private int titleSeparator = 1;
    private Insets titleMargin = new Insets(3, 3, 3, 3);
    private int iconAndTitleGap = 5;
    private int titleAndComponentsGap = 5;
    private int componentsGap = 5;
    private Component contentView;
    private Object titleBackground;
    private Color separatorColor = new Color(0, 0, 0, 80);
    private JComponent[] titleComponents;

    public TitlePanel(String title) {
        this(null, title, null);
    }

    public TitlePanel(Icon icon, String title) {
        this(icon, title, null);
    }

    public TitlePanel(String title, JComponent[] titleComponents) {
        this(null, title, titleComponents);
    }

    public TitlePanel(Icon icon, String title, JComponent[] titleComponents) {
        this.paintedPanel = new PaintedPanel();
        if (defaultTitleBackground instanceof Gradient) {
            this.setTitleBackground((Gradient)defaultTitleBackground);
        } else if (defaultTitleBackground instanceof Color) {
            this.setTitleBackground((Color)defaultTitleBackground);
        }
        this.titleBackground = defaultTitleBackground;
        this.setBorder(BorderFactory.createLineBorder(this.separatorColor));
        super.setLayout(new TitlePanelLayout());
        this.setOpaque(false);
        if (icon != null) {
            this.titleIcon = new JLabel(icon);
        }
        if (title == null || title.length() == 0) {
            title = " ";
        }
        this.titleLabel = new JLabel(title);
        this.titleComponents = titleComponents;
        this.build();
    }

    private void build() {
        super.add(this.paintedPanel);
        if (this.titleIcon != null) {
            super.add(this.titleIcon);
        }
        super.add(this.titleLabel);
        if (this.titleComponents != null) {
            for (JComponent titleComponent : this.titleComponents) {
                super.add(titleComponent);
            }
        }
        this.updateZOrders();
    }

    private void updateZOrders() {
        int z = 0;
        if (this.titleIcon != null) {
            this.setComponentZOrder(this.titleIcon, z++);
        }
        this.setComponentZOrder(this.titleLabel, z++);
        if (this.titleComponents != null) {
            for (JComponent titleComponent : this.titleComponents) {
                this.setComponentZOrder(titleComponent, z++);
            }
        }
        if (this.contentView != null) {
            this.setComponentZOrder(this.contentView, z++);
        }
        this.setComponentZOrder(this.paintedPanel, z++);
    }

    @Override
    public final void setLayout(LayoutManager arg0) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        super.paintComponent(g2d);
        Insets insets = this.getInsets();
        if (this.titleSeparator > 0) {
            g2d.setColor(this.getSeparatorColor());
            g2d.fillRect(insets.left, this.titleSeparatorY, this.getWidth() - (insets.left + insets.right), this.titleSeparator);
        }
    }

    @Override
    protected final void paintBorder(Graphics g) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, g, 0, this.borderY, this.getWidth(), this.getHeight() - this.borderY);
        }
    }

    public void setTitleGaps(int gap1, int gap2, int gap3) {
        this.iconAndTitleGap = Math.max(gap1, 0);
        this.titleAndComponentsGap = Math.max(gap2, 0);
        this.componentsGap = Math.max(gap3, 0);
    }

    public int getGapBetweenIconAndTitle() {
        return this.iconAndTitleGap;
    }

    public int getGapBetweenTitleAndTitleComponents() {
        return this.titleAndComponentsGap;
    }

    public int getGapBetweenTitleComponents() {
        return this.componentsGap;
    }

    public void setSeparatorThickness(int thickness) {
        this.titleSeparator = Math.max(0, thickness);
    }

    @Override
    public void remove(Component arg0) {
        if (this.contentView.equals(arg0)) {
            this.removeContentView();
        }
    }

    @Override
    public void remove(int arg0) {
    }

    @Override
    public void removeAll() {
        this.removeContentView();
    }

    public void removeContentView() {
        if (this.contentView != null) {
            super.remove(this.contentView);
            this.contentView = null;
            this.updateZOrders();
        }
    }

    public void setContentView(Component component) {
        this.removeContentView();
        if (component != null) {
            this.contentView = component;
            super.add(component);
            this.updateZOrders();
        }
    }

    @Override
    public Component add(Component comp, int index) {
        this.setContentView(comp);
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.setContentView(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.setContentView(comp);
    }

    @Override
    public Component add(Component comp) {
        this.setContentView(comp);
        return comp;
    }

    @Override
    public Component add(String name, Component comp) {
        this.setContentView(comp);
        return comp;
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color separatorColor) {
        this.separatorColor = separatorColor;
    }

    @Override
    public Font getFont() {
        return this.titleLabel.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.titleLabel.setFont(font);
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public void setTitleForeground(Color color) {
        this.titleLabel.setForeground(color);
    }

    public Color getTitleForeground() {
        return this.titleLabel.getForeground();
    }

    public void setTitleBackground(Color color) {
        if (color != null) {
            this.titleBackground = color;
            this.paintedPanel.removeBackgrounds();
            this.paintedPanel.addBackground(color);
        }
    }

    public void setTitleBackground(Gradient gradient) {
        if (gradient != null && gradient.getDirection() != null && gradient.getFirstColor() != null && gradient.getSecondColor() != null) {
            this.titleBackground = gradient;
            this.paintedPanel.removeBackgrounds();
            this.paintedPanel.addBackground(gradient);
        }
    }

    public Object getTitleBackground() {
        return this.titleBackground;
    }

    public boolean hasTitleBackgroundGradient() {
        return this.titleBackground instanceof Gradient;
    }

    public Insets getTitleMargin() {
        return (Insets)this.titleMargin.clone();
    }

    public void setTitleMargin(Insets titleMargin) {
        if (titleMargin == null) {
            titleMargin = new Insets(0, 0, 0, 0);
        }
        int top = Math.max(titleMargin.top, 0);
        int left = Math.max(titleMargin.left, 0);
        int bottom = Math.max(titleMargin.bottom, 0);
        int right = Math.max(titleMargin.right, 0);
        this.titleMargin = new Insets(top, left, bottom, right);
    }

    public static Object getDefaultTitleBackground() {
        return defaultTitleBackground;
    }

    public static void setDefaultTitleBackground(Color color) {
        if (color != null) {
            defaultTitleBackground = color;
        }
    }

    public static void setDefaultTitleBackground(Gradient gradient) {
        if (gradient != null && gradient.getDirection() != null && gradient.getFirstColor() != null && gradient.getSecondColor() != null) {
            defaultTitleBackground = gradient;
        }
    }

    private class TitlePanelLayout
    implements LayoutManager {
        private TitlePanelLayout() {
        }

        private Dimension getTitlePreferredSize() {
            Dimension pdim = TitlePanel.this.titleLabel.getPreferredSize();
            if (TitlePanel.this.titleIcon != null) {
                Dimension dim = TitlePanel.this.titleIcon.getPreferredSize();
                pdim.width += dim.width;
                pdim.width += TitlePanel.this.iconAndTitleGap;
            }
            if (TitlePanel.this.titleComponents != null && TitlePanel.this.titleComponents.length > 0) {
                pdim.width += TitlePanel.this.titleAndComponentsGap;
                pdim.width += TitlePanel.this.componentsGap * (TitlePanel.this.titleComponents.length - 1);
                for (JComponent titleComponent : TitlePanel.this.titleComponents) {
                    Dimension dim = titleComponent.getPreferredSize();
                    pdim.width += dim.width;
                }
            }
            pdim.width += ((TitlePanel)TitlePanel.this).titleMargin.left + ((TitlePanel)TitlePanel.this).titleMargin.right;
            pdim.height += ((TitlePanel)TitlePanel.this).titleMargin.top + ((TitlePanel)TitlePanel.this).titleMargin.bottom;
            return pdim;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension pdim = this.minimumLayoutSize(parent);
            Insets insets = TitlePanel.this.getInsets();
            pdim.height += TitlePanel.this.titleSeparator;
            if (TitlePanel.this.contentView != null) {
                Dimension dim = TitlePanel.this.contentView.getPreferredSize();
                pdim.height += dim.height;
                pdim.width = Math.max(pdim.width, dim.width);
            }
            pdim.width += insets.left + insets.right;
            return pdim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension pdim = this.getTitlePreferredSize();
            Insets insets = TitlePanel.this.getInsets();
            if (TitlePanel.this.titleIcon != null) {
                Dimension dim = TitlePanel.this.titleIcon.getPreferredSize();
                pdim.height = Math.max(pdim.height + insets.top, dim.height + ((TitlePanel)TitlePanel.this).titleMargin.bottom);
            } else {
                pdim.height += insets.top;
            }
            pdim.height += insets.bottom;
            return pdim;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container parent) {
            Object object = TitlePanel.this.getTreeLock();
            synchronized (object) {
                Dimension psize = parent.getSize();
                Dimension tdim = this.getTitlePreferredSize();
                Insets insets = TitlePanel.this.getInsets();
                int h = tdim.height;
                int x = insets.left + ((TitlePanel)TitlePanel.this).titleMargin.left;
                if (TitlePanel.this.titleIcon != null) {
                    Dimension dim = TitlePanel.this.titleIcon.getPreferredSize();
                    h = Math.max(h + insets.top, dim.height + ((TitlePanel)TitlePanel.this).titleMargin.bottom);
                    TitlePanel.this.titleIcon.setBounds(x, h - (dim.height + ((TitlePanel)TitlePanel.this).titleMargin.bottom), dim.width, dim.height);
                    x += dim.width;
                    x += TitlePanel.this.iconAndTitleGap;
                } else {
                    h += insets.top;
                }
                TitlePanel.this.paintedPanel.setBounds(insets.left, h - tdim.height, psize.width - (insets.left + insets.right), tdim.height);
                TitlePanel.this.borderY = h - (tdim.height + insets.top);
                int y = h - ((TitlePanel)TitlePanel.this).titleMargin.bottom;
                Dimension dim = TitlePanel.this.titleLabel.getPreferredSize();
                TitlePanel.this.titleLabel.setBounds(x, y - dim.height, dim.width, dim.height);
                if (TitlePanel.this.titleComponents != null && TitlePanel.this.titleComponents.length > 0) {
                    Dimension cdim;
                    int tw = 0;
                    for (JComponent titleComponent : TitlePanel.this.titleComponents) {
                        cdim = titleComponent.getPreferredSize();
                        tw += cdim.width;
                    }
                    x = Math.max(psize.width - (insets.right + (tw += TitlePanel.this.componentsGap * (TitlePanel.this.titleComponents.length - 1)) + ((TitlePanel)TitlePanel.this).titleMargin.right), x + dim.width);
                    for (JComponent titleComponent : TitlePanel.this.titleComponents) {
                        cdim = titleComponent.getPreferredSize();
                        titleComponent.setBounds(x, y - dim.height, cdim.width, cdim.height);
                        x += cdim.width + TitlePanel.this.componentsGap;
                    }
                }
                if (TitlePanel.this.contentView != null) {
                    y += ((TitlePanel)TitlePanel.this).titleMargin.bottom;
                    if (TitlePanel.this.titleSeparator > 0) {
                        TitlePanel.this.titleSeparatorY = y;
                        y += TitlePanel.this.titleSeparator;
                    }
                    x = insets.left;
                    TitlePanel.this.contentView.setBounds(x, y, psize.width - (insets.left + insets.right), psize.height - (y + insets.bottom));
                }
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

