/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.japura.gui.Images;
import org.japura.gui.PopupMenuBuilder;
import org.japura.gui.calendar.CalendarComponent;
import org.japura.gui.calendar.CalendarComponentType;
import org.japura.gui.calendar.DayOfWeek;
import org.japura.gui.calendar.DefaultPropertiesProvider;
import org.japura.gui.calendar.PropertiesProvider;
import org.japura.gui.calendar.components.CalendarButton;
import org.japura.gui.calendar.components.CalendarSlot;
import org.japura.gui.calendar.components.DayOfMonthSlot;
import org.japura.gui.calendar.components.DayOfWeekSlot;
import org.japura.gui.calendar.components.MonthLabel;
import org.japura.gui.calendar.components.TopBar;
import org.japura.gui.calendar.components.WeekHeaderSlot;
import org.japura.gui.calendar.components.WeekSlot;
import org.japura.gui.calendar.components.YearLabel;
import org.japura.gui.event.DateEvent;
import org.japura.gui.event.DateListener;

public class Calendar
extends JComponent {
    private static final long serialVersionUID = -3245248937315409078L;
    public static final DayOfWeek SUNDAY = DayOfWeek.SUNDAY;
    public static final DayOfWeek MONDAY = DayOfWeek.MONDAY;
    public static final DayOfWeek THURSDAY = DayOfWeek.THURSDAY;
    public static final DayOfWeek WEDNESDAY = DayOfWeek.WEDNESDAY;
    public static final DayOfWeek TUESDAY = DayOfWeek.TUESDAY;
    public static final DayOfWeek FRIDAY = DayOfWeek.FRIDAY;
    public static final DayOfWeek SATURDAY = DayOfWeek.SATURDAY;
    private PropertiesProvider propertiesProvider = new DefaultPropertiesProvider();
    private HashMap<CalendarComponentType, List<CalendarSlot>> slots;
    private CalendarButton previousMonthButton;
    private CalendarButton previousYearButton;
    private CalendarButton nextMonthButton;
    private CalendarButton nextYearButton;
    private MonthLabel monthLabel;
    private YearLabel yearLabel;
    private TopBar topPanel;
    private JPanel slotsPanel;
    private PopupMenuBuilder<CalendarComponent> popupMenuBuilder;
    private String[] weekNames;
    private String[] monthNames;
    private Long date;
    private boolean weeksEnabled = false;
    boolean dialogMode;
    private JDialog modalDialog;
    Long selectedDialogDate;

    public Calendar() {
        this(null);
    }

    public Calendar(Locale locale) {
        if (locale != null) {
            this.setLocale(locale);
        }
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        super.setLayout(new BorderLayout());
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)this.getSlotsPanel(), "Center");
        this.updateNames();
        this.slots = new HashMap();
        this.rebuild();
        this.setDate(System.currentTimeMillis());
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        if (propertiesProvider == null) {
            propertiesProvider = new DefaultPropertiesProvider();
        }
        this.propertiesProvider = propertiesProvider;
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public PopupMenuBuilder<CalendarComponent> getPopupMenuBuilder() {
        return this.popupMenuBuilder;
    }

    public void setPopupMenuBuilder(PopupMenuBuilder<CalendarComponent> popupMenuBuilder) {
        this.popupMenuBuilder = popupMenuBuilder;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.getNextYearButton().setEnabled(enabled);
        this.getNextMonthButton().setEnabled(enabled);
        this.getPreviousMonthButton().setEnabled(enabled);
        this.getPreviousYearButton().setEnabled(enabled);
        this.getMonthLabel().setEnabled(enabled);
        this.getYearLabel().setEnabled(enabled);
        for (List<CalendarSlot> list : this.slots.values()) {
            for (CalendarSlot cs : list) {
                cs.setEnabled(enabled);
            }
        }
        super.setEnabled(enabled);
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        this.updateNames();
    }

    @Override
    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    private void updateNames() {
        DateFormatSymbols dfs = new DateFormatSymbols(this.getLocale());
        this.weekNames = dfs.getShortWeekdays();
        this.monthNames = dfs.getMonths();
        Font font = this.getMonthLabel().getFont();
        FontMetrics fm = this.getMonthLabel().getFontMetrics(font);
        int width = 0;
        for (String month : this.monthNames) {
            width = Math.max(width, fm.stringWidth(month));
        }
        Dimension dim = new Dimension(width, fm.getHeight());
        this.getMonthLabel().setPreferredSize(dim);
    }

    protected void fireAllListeners(Date oldDate, Date newDate) {
        DateListener[] listeners;
        DateEvent event = new DateEvent(newDate, oldDate);
        for (DateListener listener : listeners = (DateListener[])this.listenerList.getListeners(DateListener.class)) {
            listener.dateChanged(event);
        }
    }

    public void addDateListener(DateListener listener) {
        this.listenerList.add(DateListener.class, listener);
    }

    public void removeDateListener(DateListener listener) {
        this.listenerList.remove(DateListener.class, listener);
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
    }

    private TopBar getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new TopBar(this);
            this.topPanel.setBackground(this.getPropertiesProvider().getBackground(this.topPanel));
            this.topPanel.add(this.getPreviousYearButton());
            this.topPanel.add(this.getPreviousMonthButton());
            this.topPanel.add(this.getMonthLabel());
            this.topPanel.add(this.getYearLabel());
            this.topPanel.add(this.getNextMonthButton());
            this.topPanel.add(this.getNextYearButton());
        }
        return this.topPanel;
    }

    private JPanel getSlotsPanel() {
        if (this.slotsPanel == null) {
            this.slotsPanel = new JPanel();
            this.slotsPanel.setOpaque(false);
        }
        return this.slotsPanel;
    }

    private CalendarButton getPreviousYearButton() {
        if (this.previousYearButton == null) {
            this.previousYearButton = new CalendarButton(this, CalendarComponentType.PREVIOUS_YEAR_BUTTON);
            PropertiesProvider pp = this.getPropertiesProvider();
            this.previousYearButton.setForeground(pp.getForeground(this.previousYearButton));
            this.previousYearButton.setDisabledForeground(pp.getDisabledForeground(this.previousYearButton));
            this.previousYearButton.setMouseOverForeground(pp.getMouseOverForeground(this.previousYearButton));
            this.previousYearButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (Calendar.this.isEnabled()) {
                        Calendar.this.previousYear();
                    }
                }
            });
        }
        return this.previousYearButton;
    }

    private CalendarButton getPreviousMonthButton() {
        if (this.previousMonthButton == null) {
            this.previousMonthButton = new CalendarButton(this, CalendarComponentType.PREVIOUS_MONTH_BUTTON);
            PropertiesProvider pp = this.getPropertiesProvider();
            this.previousMonthButton.setForeground(pp.getForeground(this.previousMonthButton));
            this.previousMonthButton.setDisabledForeground(pp.getDisabledForeground(this.previousMonthButton));
            this.previousMonthButton.setMouseOverForeground(pp.getMouseOverForeground(this.previousMonthButton));
            this.previousMonthButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (Calendar.this.isEnabled()) {
                        Calendar.this.previousMonth();
                    }
                }
            });
        }
        return this.previousMonthButton;
    }

    private CalendarButton getNextMonthButton() {
        if (this.nextMonthButton == null) {
            this.nextMonthButton = new CalendarButton(this, CalendarComponentType.NEXT_MONTH_BUTTON);
            PropertiesProvider pp = this.getPropertiesProvider();
            this.nextMonthButton.setForeground(pp.getForeground(this.nextMonthButton));
            this.nextMonthButton.setDisabledForeground(pp.getDisabledForeground(this.nextMonthButton));
            this.nextMonthButton.setMouseOverForeground(pp.getMouseOverForeground(this.nextMonthButton));
            this.nextMonthButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (Calendar.this.isEnabled()) {
                        Calendar.this.nextMonth();
                    }
                }
            });
        }
        return this.nextMonthButton;
    }

    private CalendarButton getNextYearButton() {
        if (this.nextYearButton == null) {
            this.nextYearButton = new CalendarButton(this, CalendarComponentType.NEXT_YEAR_BUTTON);
            PropertiesProvider pp = this.getPropertiesProvider();
            this.nextYearButton.setForeground(pp.getForeground(this.nextYearButton));
            this.nextYearButton.setDisabledForeground(pp.getDisabledForeground(this.nextYearButton));
            this.nextYearButton.setMouseOverForeground(pp.getMouseOverForeground(this.nextYearButton));
            this.nextYearButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (Calendar.this.isEnabled()) {
                        Calendar.this.nextYear();
                    }
                }
            });
        }
        return this.nextYearButton;
    }

    private MonthLabel getMonthLabel() {
        if (this.monthLabel == null) {
            this.monthLabel = new MonthLabel(this);
            this.monthLabel.setForeground(this.getPropertiesProvider().getForeground(this.monthLabel));
        }
        return this.monthLabel;
    }

    private YearLabel getYearLabel() {
        if (this.yearLabel == null) {
            this.yearLabel = new YearLabel(this);
            this.yearLabel.setForeground(this.getPropertiesProvider().getForeground(this.yearLabel));
        }
        return this.yearLabel;
    }

    private boolean isWeeksEnabled() {
        return this.weeksEnabled;
    }

    private void addSlot(CalendarSlot cs, CalendarComponentType st) {
        List<CalendarSlot> list = this.slots.get((Object)st);
        if (list == null) {
            list = new ArrayList<CalendarSlot>();
            this.slots.put(st, list);
        }
        list.add(cs);
        this.getSlotsPanel().add(cs);
    }

    private void rebuild() {
        int i;
        int columnsTotal = 7;
        if (this.isWeeksEnabled()) {
            ++columnsTotal;
        }
        this.getSlotsPanel().removeAll();
        this.getSlotsPanel().setLayout(new GridLayout(0, columnsTotal, 0, 0));
        this.slots.clear();
        if (this.isWeeksEnabled()) {
            this.addSlot(new WeekHeaderSlot(this), CalendarComponentType.WEEK_HEADER);
        }
        DayOfWeek week = this.getPropertiesProvider().getStartDayOfWeek();
        for (i = 0; i < 7; ++i) {
            String name = this.weekNames[week.getJUDayOfWeek()];
            this.addSlot(new DayOfWeekSlot(this, name, week), CalendarComponentType.DAY_WEEK_HEADER);
            week = week.nextDayOfWeek();
        }
        for (i = 0; i < columnsTotal * 6; ++i) {
            if (this.isWeeksEnabled() && i % 8 == 0) {
                this.addSlot(new WeekSlot(this), CalendarComponentType.WEEK);
                continue;
            }
            this.addSlot(new DayOfMonthSlot(this), CalendarComponentType.DAY_MONTH);
        }
        this.getSlotsPanel().revalidate();
    }

    public void update() {
        this.rebuild();
        this.updateDate();
        PropertiesProvider pp = this.getPropertiesProvider();
        this.getPreviousYearButton().setForeground(pp.getForeground(this.getPreviousYearButton()));
        this.getPreviousMonthButton().setForeground(pp.getForeground(this.getPreviousMonthButton()));
        this.getNextMonthButton().setForeground(pp.getForeground(this.getNextMonthButton()));
        this.getNextYearButton().setForeground(pp.getForeground(this.getNextYearButton()));
        this.getPreviousYearButton().setDisabledForeground(pp.getDisabledForeground(this.getPreviousYearButton()));
        this.getPreviousMonthButton().setDisabledForeground(pp.getDisabledForeground(this.getPreviousMonthButton()));
        this.getNextMonthButton().setDisabledForeground(pp.getDisabledForeground(this.getNextMonthButton()));
        this.getNextYearButton().setDisabledForeground(pp.getDisabledForeground(this.getNextYearButton()));
        this.getPreviousYearButton().setMouseOverForeground(pp.getMouseOverForeground(this.getPreviousYearButton()));
        this.getPreviousMonthButton().setMouseOverForeground(pp.getMouseOverForeground(this.getPreviousMonthButton()));
        this.getNextMonthButton().setMouseOverForeground(pp.getMouseOverForeground(this.getNextMonthButton()));
        this.getNextYearButton().setMouseOverForeground(pp.getMouseOverForeground(this.getNextYearButton()));
        this.getMonthLabel().setForeground(pp.getForeground(this.getMonthLabel()));
        this.getYearLabel().setForeground(pp.getForeground(this.getYearLabel()));
        this.getTopPanel().setBackground(pp.getBackground(this.getTopPanel()));
        this.repaint();
    }

    private void updateDate() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.date);
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        this.date = gc.getTimeInMillis();
        int currentDay = gc.get(5);
        int currentMonth = gc.get(2);
        String monthName = this.monthNames[currentMonth];
        this.getMonthLabel().setText(monthName);
        int currentYear = gc.get(1);
        this.getYearLabel().setText(Integer.toString(currentYear));
        gc.set(5, 1);
        int dayOfWeek = gc.get(7);
        DayOfWeek week = DayOfWeek.getDayOfWeek(dayOfWeek);
        DayOfWeek s = this.getPropertiesProvider().getStartDayOfWeek();
        int previous = 0;
        while (!s.equals((Object)week)) {
            s = s.nextDayOfWeek();
            ++previous;
        }
        gc.add(5, -1 * previous);
        List<CalendarSlot> list = this.slots.get((Object)CalendarComponentType.DAY_MONTH);
        for (CalendarSlot sl : list) {
            DayOfMonthSlot dms = (DayOfMonthSlot)sl;
            int day = gc.get(5);
            int month = gc.get(2);
            int year = gc.get(1);
            dms.setDate(day, month, year);
            if (month == currentMonth) {
                dms.setCurrentMonth(true);
                dms.setSelected(day == currentDay);
            } else {
                dms.setCurrentMonth(false);
                dms.setSelected(false);
            }
            gc.add(5, 1);
        }
        this.repaint();
    }

    public void previousYear() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.date);
        gc.add(1, -1);
        this.setDate(gc.getTimeInMillis());
    }

    public void nextYear() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.date);
        gc.add(1, 1);
        this.setDate(gc.getTimeInMillis());
    }

    public void nextMonth() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.date);
        gc.add(2, 1);
        this.setDate(gc.getTimeInMillis());
    }

    public void previousMonth() {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(this.date);
        gc.add(2, -1);
        this.setDate(gc.getTimeInMillis());
    }

    public DayOfWeek getDayOfWeek(CalendarComponent cc) {
        if (cc instanceof DayOfMonthSlot) {
            DayOfMonthSlot slot = (DayOfMonthSlot)cc;
            return slot.getDayOfWeek();
        }
        if (cc instanceof DayOfWeekSlot) {
            DayOfWeekSlot slot = (DayOfWeekSlot)cc;
            return slot.getDayOfWeek();
        }
        return null;
    }

    public boolean isSelected(CalendarComponent cc) {
        if (cc instanceof DayOfMonthSlot) {
            DayOfMonthSlot slot = (DayOfMonthSlot)cc;
            return slot.isSelected();
        }
        return false;
    }

    public boolean isCurrentMonth(CalendarComponent cc) {
        if (cc instanceof DayOfMonthSlot) {
            DayOfMonthSlot slot = (DayOfMonthSlot)cc;
            return slot.isCurrentMonth();
        }
        return false;
    }

    public Integer getYear(CalendarComponent cc) {
        if (cc instanceof DayOfMonthSlot) {
            DayOfMonthSlot slot = (DayOfMonthSlot)cc;
            return slot.getYear();
        }
        return null;
    }

    public Integer getMonth(CalendarComponent cc) {
        if (cc instanceof DayOfMonthSlot) {
            DayOfMonthSlot slot = (DayOfMonthSlot)cc;
            return slot.getMonth();
        }
        return null;
    }

    public Integer getDay(CalendarComponent cc) {
        if (cc instanceof DayOfMonthSlot) {
            DayOfMonthSlot slot = (DayOfMonthSlot)cc;
            return slot.getDay();
        }
        return null;
    }

    public Date getDate(CalendarComponent cc) {
        if (cc instanceof DayOfMonthSlot) {
            DayOfMonthSlot slot = (DayOfMonthSlot)cc;
            return slot.getDate();
        }
        return null;
    }

    public void setDate(long date) {
        Date oldDate = null;
        if (this.date != null) {
            oldDate = new Date(this.date);
        }
        Date newDate = new Date(date);
        this.date = date;
        this.updateDate();
        this.fireAllListeners(oldDate, newDate);
    }

    public Date getDate() {
        return new Date(this.date);
    }

    public boolean isDialogMode() {
        return this.dialogMode;
    }

    public void disposeDialog(long selectedTime) {
        if (this.isDialogMode()) {
            this.selectedDialogDate = selectedTime;
            this.getModalDialog().dispose();
        }
    }

    JDialog getModalDialog() {
        if (this.modalDialog == null) {
            this.modalDialog = new JDialog();
            ImageIcon ii = new ImageIcon(Images.CALENDAR);
            this.modalDialog.setIconImage(ii.getImage());
            this.modalDialog.add(this);
            this.modalDialog.pack();
            this.modalDialog.setResizable(false);
            this.modalDialog.setModal(true);
        }
        return this.modalDialog;
    }

    public static Long showAsDialog(Locale locale, long date, String dialogTitle, Component relativeComponent) {
        return Calendar.showAsDialog(locale, date, dialogTitle, relativeComponent, null);
    }

    public static Long showAsDialog(Locale locale, long date, String dialogTitle, Component relativeComponent, PropertiesProvider propertiesProvider) {
        Calendar calendar = new Calendar(locale);
        calendar.setDate(date);
        if (propertiesProvider != null) {
            calendar.setPropertiesProvider(propertiesProvider);
        }
        calendar.dialogMode = true;
        calendar.getModalDialog().setTitle(dialogTitle);
        calendar.getModalDialog().setLocationRelativeTo(relativeComponent);
        calendar.getModalDialog().setVisible(true);
        return calendar.selectedDialogDate;
    }
}

