/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.japura.Application;
import org.japura.controller.ControllerModel;
import org.japura.task.CancelToken;
import org.japura.task.FutureTaskWrapper;
import org.japura.task.Task;
import org.japura.task.TaskEvent;
import org.japura.task.TaskManagerEvent;
import org.japura.task.TaskSession;

abstract class AbstractTaskExecutor
extends ThreadPoolExecutor {
    private CancelToken cancelToken;
    private List<Task<?>> tasks = new ArrayList();

    protected AbstractTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    synchronized void cancel() {
        if (this.cancelToken != null) {
            this.cancelToken.cancel = true;
            this.cancelToken = null;
        }
    }

    synchronized CancelToken getCancelToken() {
        if (this.cancelToken == null) {
            this.cancelToken = new CancelToken();
        }
        return this.cancelToken;
    }

    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        Task task = (Task)runnable;
        this.tasks.add(task);
        return new FutureTaskWrapper<T>(task, value);
    }

    @Override
    protected final void beforeExecute(Thread t, Runnable r) {
        FutureTaskWrapper ftw = (FutureTaskWrapper)r;
        Task<?> task = ftw.getTask();
        Application.getTaskManager().addToDebugWindow(task);
        Application.getTaskManager().addToDebugWindow(task, TaskEvent.BEFORE);
        Application.getTaskManager().fireTaskManagerListeners(TaskManagerEvent.BEFORE_EXECUTE, task);
        Application.getTaskManager().fireTaskExecutionUIs(TaskManagerEvent.BEFORE_EXECUTE, task);
        if (task.isCanceled()) {
            return;
        }
        try {
            task.willExecute();
        }
        catch (Exception e) {
            task.setHasException(true);
            task.setException(e);
        }
    }

    final boolean hasTask() {
        return this.tasks.size() > 0;
    }

    final boolean hasTask(String controllerGroupId) {
        for (Task<?> task : this.tasks) {
            ControllerModel controller = task.getRootModel();
            if (controller == null || !controller.getGroupId().equals(controllerGroupId)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected final void afterExecute(Runnable r, Throwable t) {
        FutureTaskWrapper ftw = (FutureTaskWrapper)r;
        Task<?> task = ftw.getTask();
        this.tasks.remove(task);
        TaskSession session = task.getSession();
        List<Task<?>> nestedTasks = task.removeNestedTasks();
        for (int i = nestedTasks.size() - 1; i >= 0; --i) {
            Task<?> nestedTask = nestedTasks.get(i);
            nestedTask.setPriority();
            nestedTask.setSubmitted(false);
            nestedTask.setRootModel(task.getRootModel());
            if (nestedTask.getMessage() == null) {
                nestedTask.setMessage(task.getMessage());
            }
            if (task.hasException()) {
                nestedTask.cancel();
            } else {
                nestedTask.setCanceled(false);
            }
            Application.getTaskManager().submit(nestedTask, session);
        }
        Application.getTaskManager().notifyAfterTaskExecution(task);
        this.applyAfterExecute(task);
    }

    protected abstract boolean isWaitForEDT(Task<?> var1);

    protected void applyAfterExecute(final Task<?> task) {
        Runnable runnable = null;
        if (task.hasException()) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    Application.getTaskManager().addToDebugWindow(task, TaskEvent.ERROR);
                    task.handleException(task.getException());
                }
            };
        } else if (task.isExecuted()) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    Application.getTaskManager().addToDebugWindow(task, TaskEvent.DONE);
                    task.done();
                }
            };
        } else if (task.isCanceled()) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    Application.getTaskManager().addToDebugWindow(task, TaskEvent.CANCELED);
                    task.canceled();
                }
            };
        }
        if (runnable == null) {
            return;
        }
        if (this.isWaitForEDT(task)) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

