/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.japura.controller.ControllerModel;
import org.japura.debug.DebugComponent;
import org.japura.debug.DebugParameter;
import org.japura.debug.DebugResult;
import org.japura.gui.CheckComboBox;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.japura.gui.model.ListCheckModel;
import org.japura.task.Task;
import org.japura.task.TaskDebugLog;
import org.japura.task.TaskEvent;

class DebugTasks
extends DebugComponent {
    private static final long serialVersionUID = -387375942292452243L;
    private CheckComboBox eventComboBox;
    private CheckComboBox columnComboBox;
    private JPanel northPanel;
    private JButton clearButton;
    private JTable table;
    private List<TaskDebugLog> taskLogs;
    private List<Column> visibleColumns = new ArrayList<Column>();
    private JList tasksList;
    private JSplitPane horizontalSplit;

    public DebugTasks() {
        ListCheckModel model = this.getColumnComboBox().getModel();
        for (Column column : Column.values()) {
            model.addElement(new Object[]{column});
            if (!column.defaultEnabled) continue;
            model.addCheck(new Object[]{column});
            this.visibleColumns.add(column);
        }
        model.addListCheckListener(new ListCheckListener(){

            @Override
            public void removeCheck(ListEvent event) {
                this.updateVisibleColumns();
            }

            @Override
            public void addCheck(ListEvent event) {
                this.updateVisibleColumns();
            }

            private void updateVisibleColumns() {
                DebugTasks.this.visibleColumns.clear();
                for (Object obj : DebugTasks.this.getColumnComboBox().getModel().getCheckeds()) {
                    DebugTasks.this.visibleColumns.add((Column)((Object)obj));
                }
                DebugTasks.this.getTable().tableChanged(null);
                DebugTasks.this.getTable().repaint();
            }
        });
        this.taskLogs = new ArrayList<TaskDebugLog>();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHorizontalSplit(), "Center");
        this.add((Component)this.getNorthPanel(), "North");
    }

    private JSplitPane getHorizontalSplit() {
        if (this.horizontalSplit == null) {
            this.horizontalSplit = new JSplitPane(1);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)new JLabel(" Tasks running: name [root controller]"), "North");
            panel.add((Component)new JScrollPane(this.getTasksList()), "Center");
            this.add((Component)panel, "East");
            this.horizontalSplit.setLeftComponent(new JScrollPane(this.getTable()));
            this.horizontalSplit.setRightComponent(panel);
            this.horizontalSplit.setResizeWeight(1.0);
        }
        return this.horizontalSplit;
    }

    private JList getTasksList() {
        if (this.tasksList == null) {
            this.tasksList = new JList();
            this.tasksList.setModel(new DefaultListModel());
        }
        return this.tasksList;
    }

    private JTable getTable() {
        if (this.table == null) {
            this.table = new JTable();
            this.table.setModel(new Model());
        }
        return this.table;
    }

    private JPanel getNorthPanel() {
        if (this.northPanel == null) {
            this.northPanel = new JPanel();
            FlowLayout fl = new FlowLayout(0);
            this.northPanel.setLayout(fl);
            this.northPanel.add(new JLabel("Events:"));
            this.northPanel.add(this.getEventComboBox());
            this.northPanel.add(new JLabel("Columns:"));
            this.northPanel.add(this.getColumnComboBox());
            this.northPanel.add(this.getClearButton());
        }
        return this.northPanel;
    }

    private CheckComboBox getEventComboBox() {
        if (this.eventComboBox == null) {
            this.eventComboBox = new CheckComboBox();
            this.eventComboBox.setTextFor(CheckComboBox.NONE, "* any item selected *");
            this.eventComboBox.setTextFor(CheckComboBox.MULTIPLE, "* multiple items *");
            this.eventComboBox.setTextFor(CheckComboBox.ALL, "* all selected *");
            ListCheckModel model = this.eventComboBox.getModel();
            for (TaskEvent te : TaskEvent.values()) {
                model.addElement(new Object[]{te});
                if (te.equals((Object)TaskEvent.AFTER) || te.equals((Object)TaskEvent.BEFORE)) continue;
                model.addCheck(new Object[]{te});
            }
        }
        return this.eventComboBox;
    }

    private CheckComboBox getColumnComboBox() {
        if (this.columnComboBox == null) {
            this.columnComboBox = new CheckComboBox();
            this.columnComboBox.setTextFor(CheckComboBox.NONE, "* any item selected *");
            this.columnComboBox.setTextFor(CheckComboBox.MULTIPLE, "* multiple items *");
            this.columnComboBox.setTextFor(CheckComboBox.ALL, "* all selected *");
        }
        return this.columnComboBox;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton("Clear");
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DebugTasks.this.taskLogs.clear();
                    DebugTasks.this.getTable().revalidate();
                }
            });
        }
        return this.clearButton;
    }

    @Override
    protected String getTitle() {
        return "Tasks";
    }

    @Override
    protected DebugResult update(DebugParameter parameter) {
        if (parameter instanceof RemoveParameter) {
            RemoveParameter rp = (RemoveParameter)parameter;
            this.removeTask(rp.getTask());
            return null;
        }
        if (parameter instanceof AddParameter) {
            AddParameter ap = (AddParameter)parameter;
            this.addTask(ap.getTask());
            return null;
        }
        if (parameter instanceof AddParameterEvent) {
            AddParameterEvent ape = (AddParameterEvent)parameter;
            return this.addTask(ape.getTask(), ape.getEvent(), ape.getCurrentTime(), ape.isEdt(), ape.getQueueCount());
        }
        return null;
    }

    private void addTask(final Task<?> task) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel model = (DefaultListModel)DebugTasks.this.getTasksList().getModel();
                model.addElement(new TaskItem(task));
            }
        });
    }

    private void removeTask(final Task<?> task) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultListModel model = (DefaultListModel)DebugTasks.this.getTasksList().getModel();
                model.removeElement(new TaskItem(task));
            }
        });
    }

    public TaskDebugLog addTask(Task<?> task, TaskEvent event, long time, boolean edt, int queueTasks) {
        if (!this.getEventComboBox().getModel().isChecked((Object)event)) {
            return null;
        }
        final TaskDebugLog tl = new TaskDebugLog(task, event, time, edt, queueTasks);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugTasks.this.taskLogs.add(tl);
                DebugTasks.this.getTable().revalidate();
            }
        });
        return tl;
    }

    static class AddParameterEvent
    extends Parameter {
        private long currentTime;
        private int queueCount;
        private TaskEvent event;
        private boolean edt;

        public AddParameterEvent(Task<?> task, TaskEvent event, long currentTime, boolean edt, int queueCount) {
            super(task);
            this.event = event;
            this.queueCount = queueCount;
            this.edt = edt;
            this.currentTime = currentTime;
        }

        public long getCurrentTime() {
            return this.currentTime;
        }

        public int getQueueCount() {
            return this.queueCount;
        }

        public TaskEvent getEvent() {
            return this.event;
        }

        public boolean isEdt() {
            return this.edt;
        }
    }

    static class RemoveParameter
    extends Parameter {
        public RemoveParameter(Task<?> task) {
            super(task);
        }
    }

    static class AddParameter
    extends Parameter {
        public AddParameter(Task<?> task) {
            super(task);
        }
    }

    private static class Parameter
    extends DebugParameter {
        private Task<?> task;

        public Parameter(Task<?> task) {
            this.task = task;
        }

        public Task<?> getTask() {
            return this.task;
        }
    }

    private static class TaskItem {
        private String id;
        private String name;

        public TaskItem(Task<?> task) {
            this.id = task.getId();
            this.name = task.getName();
            if (this.name == null) {
                this.name = "---";
            }
            this.name = this.name.trim();
            ControllerModel root = task.getRootModel();
            this.name = root != null ? this.name + " [" + root.getClass().getSimpleName() + "]" : this.name + " []";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TaskItem other = (TaskItem)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public String toString() {
            return this.name;
        }
    }

    private static enum Column {
        ID("Id", false),
        NAME("Name", true),
        EVENT("Event", true),
        QUEUE_TASKS("QueueTasks", false),
        EDT("EDT", false),
        TIME_SPENT("TimeSpent", false),
        WAIT_FOR_EDT("WaitForEDT", false),
        START_TIME("StartTime", false),
        SOURCE("Source", true),
        SESSION("Session", false);

        private boolean defaultEnabled;
        private String columnName;

        private Column(String name, boolean defaultEnabled) {
            this.columnName = name;
            this.defaultEnabled = defaultEnabled;
        }

        public String toString() {
            return this.columnName;
        }
    }

    private class Model
    implements TableModel {
        private Date date = new Date();

        private Model() {
        }

        @Override
        public int getRowCount() {
            return DebugTasks.this.taskLogs.size();
        }

        @Override
        public int getColumnCount() {
            return DebugTasks.this.visibleColumns.size();
        }

        @Override
        public String getColumnName(int columnIndex) {
            Column column = (Column)((Object)DebugTasks.this.visibleColumns.get(columnIndex));
            return column.columnName;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Column column = (Column)((Object)DebugTasks.this.visibleColumns.get(columnIndex));
            TaskDebugLog tl = (TaskDebugLog)DebugTasks.this.taskLogs.get(rowIndex);
            if (column.equals((Object)Column.ID)) {
                return tl.getId();
            }
            if (column.equals((Object)Column.NAME)) {
                return tl.getName();
            }
            if (column.equals((Object)Column.EVENT)) {
                return tl.getEvent();
            }
            if (column.equals((Object)Column.QUEUE_TASKS)) {
                return Integer.toString(tl.getQueueTasks());
            }
            if (column.equals((Object)Column.EDT)) {
                if (tl.isEdt()) {
                    return "yes";
                }
                return "no";
            }
            if (column.equals((Object)Column.TIME_SPENT)) {
                if (tl.getEvent().equals((Object)TaskEvent.DO_IN_BACKGROUND)) {
                    return tl.getTimeSpent();
                }
                return "";
            }
            if (column.equals((Object)Column.WAIT_FOR_EDT)) {
                if (tl.isWaitForEDT()) {
                    return "yes";
                }
                return "no";
            }
            if (column.equals((Object)Column.START_TIME)) {
                this.date.setTime(tl.getStartTime());
                return this.date.toString();
            }
            if (column.equals((Object)Column.SOURCE)) {
                return tl.getSource();
            }
            if (column.equals((Object)Column.SESSION)) {
                return tl.getSession();
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

