/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import org.japura.controller.ControllerModel;
import org.japura.controller.Group;
import org.japura.debug.DebugComponent;
import org.japura.debug.DebugResult;
import org.japura.debug.DebugWindow;
import org.japura.task.AbstractTaskManager;
import org.japura.task.DebugTasks;
import org.japura.task.ParallelTaskExecutor;
import org.japura.task.SerialTaskExecutor;
import org.japura.task.Task;
import org.japura.task.TaskEvent;
import org.japura.task.TaskExeception;
import org.japura.task.TaskManagerEvent;
import org.japura.task.TaskSession;
import org.japura.task.ui.DefaultTaskExecutionUI;

public class DefaultTaskManager
extends AbstractTaskManager {
    private ReentrantLock lock = new ReentrantLock();
    private SerialTaskExecutor serialExecutor = new SerialTaskExecutor();
    private ParallelTaskExecutor parallelExecutor = new ParallelTaskExecutor();
    private Map<Group, SerialTaskExecutor> groupExecutors = new HashMap<Group, SerialTaskExecutor>();

    public DefaultTaskManager() {
        this.setTaskExecutionUI(new DefaultTaskExecutionUI());
    }

    @Override
    public List<DebugResult> addToDebugWindow(Task<?> task, TaskEvent event) {
        if (DebugComponent.exists(DebugTasks.class)) {
            DebugTasks.AddParameterEvent parameter = new DebugTasks.AddParameterEvent(task, event, System.currentTimeMillis(), SwingUtilities.isEventDispatchThread(), this.getQueueCount());
            return DebugComponent.publish(DebugTasks.class, parameter);
        }
        return null;
    }

    @Override
    public void addToDebugWindow(Task<?> task) {
        if (DebugComponent.exists(DebugTasks.class)) {
            DebugTasks.AddParameter parameter = new DebugTasks.AddParameter(task);
            DebugComponent.publish(DebugTasks.class, parameter);
        }
    }

    @Override
    public void removeFromDebugWindow(Task<?> task) {
        if (DebugComponent.exists(DebugTasks.class)) {
            DebugTasks.RemoveParameter parameter = new DebugTasks.RemoveParameter(task);
            DebugComponent.publish(DebugTasks.class, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Task<?> task, TaskSession session, boolean isParallel) {
        this.lock.lock();
        try {
            Group group;
            if (task.isSubmitted()) {
                throw new TaskExeception("Task already submitted");
            }
            task.setSubmitted(true);
            session = this.getTaskSessionFactory().buildTaskSession(task, session);
            this.checkSession(task, session);
            task.setSession(session);
            task.setParallel(isParallel);
            this.addToDebugWindow(task, TaskEvent.SUBMIT);
            task.submitted();
            this.fireTaskManagerListeners(TaskManagerEvent.SUBMITTED, task);
            this.fireTaskExecutionUIs(TaskManagerEvent.SUBMITTED, task);
            if (isParallel) {
                task.setCancelToken(this.parallelExecutor.getCancelToken());
                this.parallelExecutor.submit(task);
                return;
            }
            SerialTaskExecutor executor = this.serialExecutor;
            ControllerModel controller = task.getRootModel();
            if (controller != null && (executor = this.groupExecutors.get(group = controller.getGroup())) == null) {
                executor = new SerialTaskExecutor();
                this.groupExecutors.put(group, executor);
            }
            if (executor == null) {
                throw new TaskExeception("There is no executor");
            }
            task.setCancelToken(executor.getCancelToken());
            executor.submit(task);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTask(Group group) {
        if (this.parallelExecutor.hasTask(group.getId())) {
            return true;
        }
        this.lock.lock();
        try {
            SerialTaskExecutor executor = this.groupExecutors.get(group);
            if (executor != null) {
                boolean bl = executor.hasTask();
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTask() {
        this.lock.lock();
        try {
            for (SerialTaskExecutor executor : this.groupExecutors.values()) {
                if (!executor.hasTask()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.serialExecutor.hasTask() || this.parallelExecutor.hasTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(String controllerGroupId) {
        if (controllerGroupId != null) {
            this.lock.lock();
            try {
                for (Map.Entry<Group, SerialTaskExecutor> entry : this.groupExecutors.entrySet()) {
                    Group group = entry.getKey();
                    if (!group.getId().equals(controllerGroupId)) continue;
                    entry.getValue().cancel();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAll() {
        this.parallelExecutor.cancel();
        this.serialExecutor.cancel();
        this.lock.lock();
        try {
            for (SerialTaskExecutor executor : this.groupExecutors.values()) {
                executor.cancel();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getQueueCount() {
        int count = 0;
        this.lock.lock();
        try {
            for (SerialTaskExecutor executor : this.groupExecutors.values()) {
                count += executor.getQueue().size();
            }
        }
        finally {
            this.lock.unlock();
        }
        count += this.serialExecutor.getQueue().size();
        return count += this.parallelExecutor.getQueue().size();
    }

    @Override
    public DebugComponent createDebugPanel() {
        DebugTasks component = new DebugTasks();
        DebugComponent.add(component);
        return component;
    }

    @Override
    public void showDebugWindow() {
        DebugWindow.showDebugWindow(this.createDebugPanel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAfterTaskExecution(Task<?> task) {
        this.lock.lock();
        try {
            ControllerModel controller = task.getRootModel();
            if (controller == null) {
                return;
            }
            Group group = controller.getGroup();
            SerialTaskExecutor executor = this.groupExecutors.get(group);
            if (executor != null && !executor.hasTask()) {
                this.groupExecutors.remove(group);
            }
        }
        finally {
            this.lock.unlock();
            this.addToDebugWindow(task, TaskEvent.AFTER);
            this.removeFromDebugWindow(task);
            this.fireTaskManagerListeners(TaskManagerEvent.AFTER_EXECUTE, task);
            this.fireTaskExecutionUIs(TaskManagerEvent.AFTER_EXECUTE, task);
        }
    }
}

