/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.japura.task.FutureTaskWrapper;

class FifoBlockingQueue
extends AbstractQueue<Runnable>
implements BlockingQueue<Runnable> {
    private List<Runnable> queue = new ArrayList<Runnable>();

    FifoBlockingQueue() {
    }

    @Override
    public synchronized Runnable poll() {
        if (this.queue.size() > 0) {
            return this.queue.remove(0);
        }
        return null;
    }

    @Override
    public synchronized Runnable peek() {
        if (this.queue.size() > 0) {
            return this.queue.get(0);
        }
        return null;
    }

    @Override
    public synchronized boolean offer(Runnable e) {
        this.queue(e);
        return true;
    }

    @Override
    public synchronized void put(Runnable e) throws InterruptedException {
        this.queue(e);
    }

    @Override
    public synchronized boolean offer(Runnable e, long timeout, TimeUnit unit) throws InterruptedException {
        this.queue(e);
        return true;
    }

    private synchronized void queue(Runnable e) {
        FutureTaskWrapper fw = (FutureTaskWrapper)e;
        if (fw.getTask().isPriority()) {
            this.queue.add(0, e);
            fw.getTask().clearPriority();
        } else {
            this.queue.add(e);
        }
    }

    @Override
    public synchronized Runnable take() throws InterruptedException {
        if (this.queue.size() > 0) {
            return this.queue.remove(0);
        }
        return null;
    }

    @Override
    public synchronized Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.remove(0);
    }

    @Override
    public synchronized int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public synchronized int drainTo(Collection<? super Runnable> c) {
        c.addAll(this.queue);
        int count = this.queue.size();
        this.queue.clear();
        return count;
    }

    @Override
    public synchronized int drainTo(Collection<? super Runnable> c, int maxElements) {
        int count;
        for (count = 0; count <= maxElements && this.queue.size() > 0; ++count) {
            c.add(this.queue.remove(0));
        }
        this.queue.removeAll(c);
        return count;
    }

    @Override
    public synchronized Iterator<Runnable> iterator() {
        return this.queue.iterator();
    }

    @Override
    public synchronized int size() {
        return this.queue.size();
    }
}

