/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.util.ArrayList;
import java.util.List;
import org.japura.MethodNotImplementedException;
import org.japura.controller.Group;
import org.japura.debug.DebugComponent;
import org.japura.debug.DebugResult;
import org.japura.task.AbstractTaskManager;
import org.japura.task.Task;
import org.japura.task.TaskEvent;
import org.japura.task.TaskManagerEvent;
import org.japura.task.TaskSession;

public class MockTaskManager
extends AbstractTaskManager {
    private List<Task<?>> executedTasks = new ArrayList();

    private void execute(Task<?> currentTask) {
        this.executedTasks.add(currentTask);
        this.fireTaskManagerListeners(TaskManagerEvent.SUBMITTED, currentTask);
        this.fireTaskExecutionUIs(TaskManagerEvent.SUBMITTED, currentTask);
        this.fireTaskManagerListeners(TaskManagerEvent.BEFORE_EXECUTE, currentTask);
        this.fireTaskExecutionUIs(TaskManagerEvent.BEFORE_EXECUTE, currentTask);
        if (currentTask.isCanceled()) {
            currentTask.canceled();
            this.fireTaskManagerListeners(TaskManagerEvent.AFTER_EXECUTE, currentTask);
            this.fireTaskExecutionUIs(TaskManagerEvent.AFTER_EXECUTE, currentTask);
        } else {
            try {
                currentTask.doInBackground();
            }
            catch (Exception e) {
                currentTask.handleException(e);
            }
            currentTask.done();
            this.fireTaskManagerListeners(TaskManagerEvent.AFTER_EXECUTE, currentTask);
            this.fireTaskExecutionUIs(TaskManagerEvent.AFTER_EXECUTE, currentTask);
            for (Task<?> nestedTask : currentTask.getNestedTasks()) {
                nestedTask.setRootModel(currentTask.getRootModel());
                nestedTask.setSession(currentTask.getSession());
                if (nestedTask.getMessage() == null) {
                    nestedTask.setMessage(currentTask.getMessage());
                }
                if (currentTask.hasException()) {
                    nestedTask.cancel();
                } else {
                    nestedTask.setCanceled(false);
                }
                this.execute(nestedTask);
            }
        }
    }

    @Override
    public void submit(Task<?> task, TaskSession session, boolean isParallel) {
        session = this.getTaskSessionFactory().buildTaskSession(task, session);
        this.checkSession(task, session);
        task.setSession(session);
        this.executedTasks = new ArrayList();
        this.execute(task);
    }

    @Override
    public boolean hasTask(Group group) {
        return false;
    }

    @Override
    public boolean hasTask() {
        return false;
    }

    @Override
    public void cancel(String controllerGroupId) {
    }

    @Override
    public void cancelAll() {
    }

    @Override
    public int getQueueCount() {
        return 0;
    }

    @Override
    public DebugComponent createDebugPanel() {
        throw new MethodNotImplementedException();
    }

    @Override
    public void showDebugWindow() {
        throw new MethodNotImplementedException();
    }

    public List<Task<?>> getExecutedTasks() {
        return this.executedTasks;
    }

    @Override
    public List<DebugResult> addToDebugWindow(Task<?> task, TaskEvent event) {
        return new ArrayList<DebugResult>();
    }

    @Override
    public void addToDebugWindow(Task<?> task) {
    }

    @Override
    public void removeFromDebugWindow(Task<?> task) {
    }

    @Override
    public void notifyAfterTaskExecution(Task<?> task) {
    }
}

