/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import org.japura.controller.Controller;
import org.japura.controller.ControllerModel;
import org.japura.debug.DebugResult;
import org.japura.task.Task;
import org.japura.task.TaskEvent;
import org.japura.task.TaskSession;

class TaskDebugLog
extends DebugResult {
    private String id;
    private String name;
    private String source;
    private TaskEvent event;
    private long time;
    private boolean edt;
    private boolean waitForEDT;
    private int queueTasks;
    private long timeSpent;
    private String session;

    public TaskDebugLog(Task<?> task, TaskEvent event, long time, boolean edt, int queueTasks) {
        this.id = task.getId();
        this.queueTasks = queueTasks;
        this.name = task.getName();
        this.time = time;
        this.event = event;
        this.edt = edt;
        this.waitForEDT = task.isWaitForEDT();
        this.timeSpent = task.getBackgroundTimeSpent();
        ControllerModel controller = task.getRootModel();
        this.source = controller == null ? "TaskManager" : (controller instanceof Controller ? controller.getClass().getSimpleName() + " [" + ((Controller)controller).stringToDebugComponent() + "]" : controller.getClass().getSimpleName());
        TaskSession session = task.getSession();
        this.session = session.getClass().getName() + " [" + session.getId() + "]";
    }

    public int getQueueTasks() {
        return this.queueTasks;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isEdt() {
        return this.edt;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public TaskEvent getEvent() {
        return this.event;
    }

    public boolean isWaitForEDT() {
        return this.waitForEDT;
    }

    public long getStartTime() {
        return this.time;
    }

    public void setTimeSpent(long timeSpent) {
        this.timeSpent = timeSpent;
    }

    public String getTimeSpent() {
        if (this.timeSpent < 1000L) {
            return Long.toString(this.timeSpent) + "ms";
        }
        long ms = this.timeSpent % 1000L;
        long s = this.timeSpent / 1000L;
        long m = this.timeSpent / 60000L;
        long h = this.timeSpent / 3600000L;
        StringBuilder sb = new StringBuilder();
        if (h > 0L) {
            sb.append(h);
            sb.append("h");
        }
        if (m > 0L) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(m);
            sb.append("m");
        }
        if (s > 0L) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(s);
            sb.append("s");
        }
        if (ms > 0L) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(ms);
            sb.append("ms");
        }
        return sb.toString();
    }

    public String getSession() {
        return this.session;
    }
}

