/*
 * Decompiled with CFR 0.152.
 */
package org.japura.task;

import java.util.List;
import org.japura.task.Task;

public class TaskSequence {
    private Task<?> firstTask;
    private Task<?> lastTask;
    private String message;

    public TaskSequence() {
    }

    public TaskSequence(List<Task<?>> tasks) {
        for (Task<?> task : tasks) {
            this.add(task);
        }
    }

    public TaskSequence(Task<?>[] tasks) {
        for (Task<?> task : tasks) {
            this.add(task);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.updateFirstTaskMessage();
    }

    private void updateFirstTaskMessage() {
        if (this.getFirstTask() != null && this.getFirstTask().getMessage() == null) {
            this.getFirstTask().setMessage(this.getMessage());
        }
    }

    public final void add(TaskSequence sequence) {
        if (this.firstTask == null) {
            this.firstTask = sequence.getFirstTask();
            this.updateFirstTaskMessage();
        } else {
            this.lastTask.addNestedTask(sequence.getFirstTask());
        }
        this.lastTask = sequence.getLastTask();
    }

    public final void add(Task<?> task) {
        if (this.firstTask == null) {
            this.firstTask = task;
            this.updateFirstTaskMessage();
        } else {
            this.lastTask.addNestedTask(task);
        }
        this.lastTask = task;
    }

    Task<?> getLastTask() {
        return this.lastTask;
    }

    public final Task<?> getFirstTask() {
        return this.firstTask;
    }

    public final boolean hasTask() {
        return this.getFirstTask() != null;
    }
}

