/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.multifile.io;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.AbstractRasterFileDataParameters;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.multifile.io.MultiFileDataParameters;
import org.gvsig.raster.multifile.io.MultiFileProvider;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class MultiFileDataParametersImpl
extends AbstractRasterFileDataParameters
implements MultiFileDataParameters {
    private List<RasterProvider> providerList = new ArrayList<RasterProvider>();

    public MultiFileDataParametersImpl() {
        this.initialize();
    }

    protected void initialize() {
        this.delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject(MultiFileDataParametersImpl.registerDynClass());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        List parameters = state.getList("parameters");
        for (int i = 0; i < parameters.size(); ++i) {
            try {
                DefaultRasterStore dSet = new DefaultRasterStore();
                AbstractRasterProvider provider = (AbstractRasterProvider)dataManager.createProvider((DataStoreProviderServices)dSet, (DataStoreParameters)parameters.get(i));
                this.addProvider((DataStoreProvider)provider);
                continue;
            }
            catch (InitializeException e) {
                throw new PersistenceException((Throwable)e);
            }
            catch (ProviderNotRegisteredException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        List<RasterProvider> provList = this.getProviders();
        ArrayList<RasterDataParameters> rasterDataParametersList = new ArrayList<RasterDataParameters>();
        for (int j = 0; j < provList.size(); ++j) {
            rasterDataParametersList.add(provList.get(j).getDataParameters());
        }
        state.set("parameters", rasterDataParametersList);
    }

    public static DynStruct registerDynClass() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("MultiFileDataParameters_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(MultiFileDataParametersImpl.class, "MultiFileDataParameters_Persistent", "MultiFileDataParameters Persistent", null, null);
            AbstractRasterDataParameters.registerDynClass((DynStruct)definition);
        }
        definition.addDynFieldList("parameters").setClassOfItems(RasterDataParameters.class).setMandatory(false);
        return definition;
    }

    @Override
    public void removeAllProviders() {
        this.getProviders().clear();
        this.getParams().clear();
    }

    @Override
    public boolean hasProviders() {
        return this.getProviders().size() > 0;
    }

    @Override
    public void removeProvider(URI uri) {
        if (this.getProviders() != null) {
            List<RasterProvider> provList = this.getProviders();
            List<RasterDataParameters> paramList = this.getParams();
            for (int i = 0; i < provList.size(); ++i) {
                RasterProvider rProv = provList.get(i);
                if (rProv.getURIOfFirstProvider().compareTo(uri) != 0) continue;
                provList.remove(i);
                paramList.remove(i);
                return;
            }
        }
    }

    @Override
    public void addProviderNotTiled(DataStoreProvider provider) {
        RasterProvider prov;
        if (provider instanceof RasterProvider && !(prov = (RasterProvider)provider).isTiled()) {
            this.addToList(prov);
        }
    }

    @Override
    public void setFirstProvider(DataStoreProvider provider) {
        if (provider instanceof RasterProvider) {
            RasterProvider prov = (RasterProvider)provider;
            if (this.getProviders() != null) {
                this.getProviders().set(0, prov);
                this.getParams().set(0, prov.getDataParameters());
            }
        }
    }

    @Override
    public void addProvider(DataStoreProvider provider) {
        if (provider instanceof RasterProvider) {
            RasterProvider prov = (RasterProvider)provider;
            this.addToList(prov);
        }
    }

    @Override
    public void addProvider(RasterDataStore rasterDataStore) {
        if (rasterDataStore instanceof DefaultRasterStore) {
            RasterProvider prov = (RasterProvider)((DefaultRasterStore)rasterDataStore).getProvider();
            this.addToList(prov);
        }
    }

    private void addToList(RasterProvider prov) {
        this.addProviderToList(prov);
        this.addParamToList(prov);
    }

    private List<RasterDataParameters> getParams() {
        return (List)this.getDynValue("parameters");
    }

    private void addParamToList(RasterProvider prov) {
        List<RasterDataParameters> paramList = this.getParams();
        if (paramList == null) {
            paramList = new ArrayList<RasterDataParameters>();
            paramList.add(prov.getDataParameters());
            this.setDynValue("parameters", paramList);
        } else {
            paramList.add(prov.getDataParameters());
        }
    }

    @Override
    public List<RasterProvider> getProviders() {
        return this.providerList;
    }

    private void addProviderToList(RasterProvider prov) {
        List<RasterProvider> provList = this.getProviders();
        if (provList == null) {
            provList = new ArrayList<RasterProvider>();
            provList.add(prov);
            this.setDynValue("parameters", provList);
        } else {
            provList.add(prov);
        }
    }

    public void setProviders(ArrayList<RasterProvider> provList) {
        ArrayList<RasterDataParameters> paramsList = new ArrayList<RasterDataParameters>();
        for (int i = 0; i < provList.size(); ++i) {
            paramsList.add(provList.get(i).getDataParameters());
        }
        this.setDynValue("parameters", paramsList);
        this.providerList = provList;
    }

    public String getDataStoreName() {
        return MultiFileProvider.NAME;
    }

    public String getDescription() {
        return MultiFileProvider.DESCRIPTION;
    }
}

