/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitStream {
    InputStream in;
    OutputStream out;
    int bits;
    int bits_left;
    boolean readEOF;
    private static final int[] masks = new int[32];

    public BitStream(InputStream i) {
        this.in = i;
        this.bits = 0;
        this.bits_left = 0;
        this.readEOF = false;
    }

    public BitStream(OutputStream o) {
        this.out = o;
        this.bits = 0;
        this.bits_left = 0;
        this.readEOF = false;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        }
    }

    public int getBits(int count) throws IOException {
        if (count < 32) {
            while (this.bits_left < count) {
                int r = this.in.read();
                if (r < 0) {
                    this.readEOF = true;
                    break;
                }
                this.bits <<= 8;
                this.bits |= r & 0xFF;
                this.bits_left += 8;
            }
            this.bits_left -= count;
            return this.bits >> this.bits_left & masks[count];
        }
        if (count == 32) {
            return this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
        }
        return 0;
    }

    public boolean atEndOfFile() {
        return this.readEOF && this.bits_left <= 0;
    }

    public void putBit(int i) throws IOException {
        this.bits <<= 1;
        this.bits |= i;
        ++this.bits_left;
        if (this.bits_left == 8) {
            this.out.write(this.bits);
            this.bits = 0;
            this.bits_left = 0;
        }
    }

    public void putRunBits(int i, int len) throws IOException {
        int j = len - 1;
        while (j >= 0) {
            if (this.bits_left != 0 || j < 8) {
                this.putBit(i);
                --j;
                continue;
            }
            if (i == 0) {
                this.out.write(0);
            } else {
                this.out.write(255);
            }
            j -= 8;
        }
    }

    public int available() throws IOException {
        if (this.bits_left == 0 && this.in.available() <= 0) {
            return 0;
        }
        return 1;
    }

    public void skipByte() throws IOException {
        this.bits_left = 0;
        this.bits = 0;
    }

    static {
        for (int i = 0; i < 32; ++i) {
            BitStream.masks[i] = (1 << i) - 1;
        }
    }
}

