/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.icepdf.core.io.BitStream;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.ImageUtility;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.filters.CCITTFax;
import org.icepdf.core.pobjects.filters.CCITTFaxDecoder;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceN;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.ICCBased;
import org.icepdf.core.pobjects.graphics.Indexed;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Separation;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class ImageStream
extends Stream {
    private static final Logger logger = Logger.getLogger(ImageStream.class.toString());
    public static final Name TYPE_VALUE = new Name("Image");
    public static final Name BITSPERCOMPONENT_KEY = new Name("BitsPerComponent");
    public static final Name BPC_KEY = new Name("BPC");
    public static final Name DECODE_KEY = new Name("Decode");
    public static final Name D_KEY = new Name("D");
    public static final Name SMASK_KEY = new Name("SMask");
    public static final Name MASK_KEY = new Name("Mask");
    public static final Name JBIG2GLOBALS_KEY = new Name("JBIG2Globals");
    public static final Name DECODEPARMS_KEY = new Name("DecodeParms");
    public static final Name DP_KEY = new Name("DP");
    public static final Name K_KEY = new Name("K");
    public static final Name ENCODEDBYTEALIGN_KEY = new Name("EncodedByteAlign");
    public static final Name COLUMNS_KEY = new Name("Columns");
    public static final Name ROWS_KEY = new Name("Rows");
    public static final Name BLACKIS1_KEY = new Name("BlackIs1");
    protected static final String[] CCITTFAX_DECODE_FILTERS = new String[]{"CCITTFaxDecode", "/CCF", "CCF"};
    protected static final String[] DCT_DECODE_FILTERS = new String[]{"DCTDecode", "/DCT", "DCT"};
    protected static final String[] JBIG2_DECODE_FILTERS = new String[]{"JBIG2Decode"};
    protected static final String[] JPX_DECODE_FILTERS = new String[]{"JPXDecode"};
    private static double pageRatio = Defs.sysPropertyDouble("org.icepdf.core.pageRatio", 0.7071917808219178);
    private static boolean forceJaiccittfax = Defs.sysPropertyBoolean("org.icepdf.core.ccittfax.jai", false);
    private PColorSpace colourSpace;
    private final Object colorSpaceAssignmentLock = new Object();
    private static boolean isLevigoJBIG2ImageReaderClass;
    public static boolean CHECK_PARENT_BLACK_IS_1;
    private int width;
    private int height;

    public ImageStream(Library l, HashMap h, SeekableInputConstrainedWrapper streamInputWrapper) {
        super(l, h, streamInputWrapper);
        this.init();
    }

    public ImageStream(Library l, HashMap h, byte[] rawBytes) {
        super(l, h, rawBytes);
        this.init();
    }

    public void init() {
        this.width = this.library.getInt(this.entries, WIDTH_KEY);
        this.height = this.library.getInt(this.entries, HEIGHT_KEY);
        if (this.height == 0) {
            this.height = (int)(1.0 / pageRatio * (double)this.width);
        } else if (this.width == 0) {
            this.width = (int)(pageRatio * (double)this.height);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BufferedImage getImage(GraphicsState graphicsState, Resources resources) throws InterruptedException {
        ImageStream smaskStream;
        int i;
        int j;
        Object tmp;
        if (this.pObjectReference != null && (tmp = this.library.getImagePool().get(this.pObjectReference)) != null) {
            return tmp;
        }
        tmp = this.colorSpaceAssignmentLock;
        synchronized (tmp) {
            Object o = this.entries.get(COLORSPACE_KEY);
            if (resources != null && o != null) {
                this.colourSpace = resources.getColorSpace(o);
            }
            if (this.colourSpace == null) {
                this.colourSpace = new DeviceGray(this.library, null);
            }
        }
        boolean isImageMask = this.isImageMask();
        int bitsPerComponent = this.library.getInt(this.entries, BITSPERCOMPONENT_KEY);
        if (isImageMask && bitsPerComponent == 0) {
            bitsPerComponent = 1;
        }
        int colorSpaceCompCount = this.colourSpace.getNumComponents();
        int maxValue = (int)Math.pow(2.0, bitsPerComponent) - 1;
        float[] decode = new float[2 * colorSpaceCompCount];
        List decodeVec = (List)this.library.getObject(this.entries, DECODE_KEY);
        if (decodeVec == null) {
            j = 0;
            for (i = 0; i < colorSpaceCompCount; ++i) {
                decode[j++] = 0.0f;
                decode[j++] = 1.0f / (float)maxValue;
            }
        } else {
            j = 0;
            for (i = 0; i < colorSpaceCompCount; ++i) {
                float Dmin = ((Number)decodeVec.get(j)).floatValue();
                float Dmax = ((Number)decodeVec.get(j + 1)).floatValue();
                decode[j++] = Dmin;
                decode[j++] = (Dmax - Dmin) / (float)maxValue;
            }
        }
        BufferedImage smaskImage = null;
        BufferedImage maskImage = null;
        int[] maskMinRGB = null;
        int[] maskMaxRGB = null;
        int maskMinIndex = -1;
        int maskMaxIndex = -1;
        Object smaskObj = this.library.getObject(this.entries, SMASK_KEY);
        Object maskObj = this.library.getObject(this.entries, MASK_KEY);
        if (smaskObj instanceof Stream && (smaskStream = (ImageStream)smaskObj).isImageSubtype()) {
            smaskImage = smaskStream.getImage(graphicsState, resources);
        }
        if (maskObj != null && smaskImage == null) {
            if (maskObj instanceof Stream) {
                ImageStream maskStream = (ImageStream)maskObj;
                if (maskStream.isImageSubtype()) {
                    maskImage = maskStream.getImage(graphicsState, resources);
                }
            } else if (maskObj instanceof List) {
                List maskVector = (List)maskObj;
                int[] maskMinOrigCompsInt = new int[colorSpaceCompCount];
                int[] maskMaxOrigCompsInt = new int[colorSpaceCompCount];
                for (int i2 = 0; i2 < colorSpaceCompCount; ++i2) {
                    if (i2 * 2 < maskVector.size()) {
                        maskMinOrigCompsInt[i2] = ((Number)maskVector.get(i2 * 2)).intValue();
                    }
                    if (i2 * 2 + 1 >= maskVector.size()) continue;
                    maskMaxOrigCompsInt[i2] = ((Number)maskVector.get(i2 * 2 + 1)).intValue();
                }
                if (this.colourSpace instanceof Indexed) {
                    Indexed icolourSpace = (Indexed)this.colourSpace;
                    Color[] colors = icolourSpace.accessColorTable();
                    if (colors != null && maskMinOrigCompsInt.length >= 1 && maskMaxOrigCompsInt.length >= 1) {
                        maskMinIndex = maskMinOrigCompsInt[0];
                        maskMaxIndex = maskMaxOrigCompsInt[0];
                        if (maskMinIndex >= 0 && maskMinIndex < colors.length && maskMaxIndex >= 0 && maskMaxIndex < colors.length) {
                            Color minColor = colors[maskMinOrigCompsInt[0]];
                            Color maxColor = colors[maskMaxOrigCompsInt[0]];
                            maskMinRGB = new int[]{minColor.getRed(), minColor.getGreen(), minColor.getBlue()};
                            maskMaxRGB = new int[]{maxColor.getRed(), maxColor.getGreen(), maxColor.getBlue()};
                        }
                    }
                } else {
                    PColorSpace.reverseInPlace(maskMinOrigCompsInt);
                    PColorSpace.reverseInPlace(maskMaxOrigCompsInt);
                    float[] maskMinOrigComps = new float[colorSpaceCompCount];
                    float[] maskMaxOrigComps = new float[colorSpaceCompCount];
                    this.colourSpace.normaliseComponentsToFloats(maskMinOrigCompsInt, maskMinOrigComps, (1 << bitsPerComponent) - 1);
                    this.colourSpace.normaliseComponentsToFloats(maskMaxOrigCompsInt, maskMaxOrigComps, (1 << bitsPerComponent) - 1);
                    Color minColor = this.colourSpace.getColor(maskMinOrigComps);
                    Color maxColor = this.colourSpace.getColor(maskMaxOrigComps);
                    PColorSpace.reverseInPlace(maskMinOrigComps);
                    PColorSpace.reverseInPlace(maskMaxOrigComps);
                    maskMinRGB = new int[]{minColor.getRed(), minColor.getGreen(), minColor.getBlue()};
                    maskMaxRGB = new int[]{maxColor.getRed(), maxColor.getGreen(), maxColor.getBlue()};
                }
            }
        }
        BufferedImage image = this.getImage(this.colourSpace, graphicsState, this.width, this.height, colorSpaceCompCount, bitsPerComponent, isImageMask, decode, smaskImage, maskImage, maskMinRGB, maskMaxRGB, maskMinIndex, maskMaxIndex);
        if (this.pObjectReference != null) {
            this.library.getImagePool().put(this.pObjectReference, image);
        }
        return image;
    }

    private BufferedImage getImage(PColorSpace colourSpace, GraphicsState graphicsState, int width, int height, int colorSpaceCompCount, int bitsPerComponent, boolean isImageMask, float[] decode, BufferedImage sMaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB, int maskMinIndex, int maskMaxIndex) {
        byte[] data;
        BufferedImage decodedImage = null;
        if (this.shouldUseDCTDecode()) {
            decodedImage = this.dctDecode(width, height, colourSpace, bitsPerComponent, decode);
        } else if (this.shouldUseJBIG2Decode()) {
            decodedImage = this.jbig2Decode(width, height, colourSpace, bitsPerComponent, decode);
        } else if (this.shouldUseJPXDecode()) {
            decodedImage = this.jpxDecode(width, height, colourSpace, bitsPerComponent, decode);
        } else if (this.shouldUseCCITTFaxDecode()) {
            decodedImage = this.ccittFaxDecode(colourSpace, graphicsState, width, height, colorSpaceCompCount, bitsPerComponent, isImageMask, decode, sMaskImage, maskImage, maskMinRGB, maskMaxRGB, maskMinIndex, maskMaxIndex, false);
        } else {
            data = this.getDecodedStreamBytes(width * height * colourSpace.getNumComponents() * bitsPerComponent / 8);
            int dataLength = data.length;
            try {
                decodedImage = ImageUtility.makeImageWithRasterFromBytes(colourSpace, graphicsState, width, height, colorSpaceCompCount, bitsPerComponent, isImageMask, decode, sMaskImage, maskImage, maskMinRGB, maskMaxRGB, maskMinIndex, maskMaxIndex, data, dataLength);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error building image raster.", e);
            }
        }
        if (decodedImage == null) {
            data = this.getDecodedStreamBytes(width * height * colourSpace.getNumComponents() * bitsPerComponent / 8);
            decodedImage = this.parseImage(width, height, colourSpace, isImageMask, graphicsState, bitsPerComponent, decode, data);
        }
        if (decodedImage != null) {
            if (isImageMask) {
                decodedImage = ImageUtility.applyExplicitMask(decodedImage, graphicsState.getFillColor());
            }
            if (sMaskImage != null) {
                decodedImage = ImageUtility.applyExplicitSMask(decodedImage, sMaskImage);
            }
            if (maskImage != null) {
                decodedImage = ImageUtility.applyExplicitMask(decodedImage, maskImage);
            }
            return decodedImage;
        }
        return null;
    }

    private BufferedImage ccittFaxDecode(PColorSpace colourSpace, GraphicsState graphicsState, int width, int height, int colorSpaceCompCount, int bitsPerComponent, boolean isImageMask, float[] decode, BufferedImage sMaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB, int maskMinIndex, int maskMaxIndex, boolean forceJAI) {
        BufferedImage decodedImage;
        block19: {
            int i;
            int dataLength;
            byte[] data;
            block17: {
                decodedImage = null;
                data = this.getDecodedStreamBytes(width * height * colourSpace.getNumComponents() * bitsPerComponent / 8);
                dataLength = data.length;
                try {
                    if (forceJaiccittfax || forceJAI) {
                        throw new Throwable("Forcing CCITTFAX decode via JAI");
                    }
                    data = this.ccittFaxDecode(data, width, height);
                    dataLength = data.length;
                }
                catch (Throwable e) {
                    try {
                        decodedImage = CCITTFax.attemptDeriveBufferedImageFromBytes(this, this.library, this.entries, graphicsState.getFillColor());
                    }
                    catch (Throwable e1) {
                        data = this.ccittFaxDecode(data, width, height);
                        dataLength = data.length;
                    }
                    if (decodedImage == null) break block17;
                    return decodedImage;
                }
            }
            boolean allWhite = true;
            boolean allBlack = true;
            for (i = 0; i < dataLength; ++i) {
                if (data[i] == -1) continue;
                allWhite = false;
                break;
            }
            for (i = 0; i < dataLength; ++i) {
                if (data[i] == 0) continue;
                allBlack = false;
                break;
            }
            if (!forceJaiccittfax && (allBlack || allWhite)) {
                try {
                    decodedImage = CCITTFax.attemptDeriveBufferedImageFromBytes(this, this.library, this.entries, graphicsState.getFillColor());
                    if (decodedImage != null) {
                        return decodedImage;
                    }
                }
                catch (Throwable e1) {
                    logger.finer("Failed to do secondary load attempt with JAI");
                }
            } else if (forceJaiccittfax && (allBlack || allWhite)) {
                try {
                    data = this.ccittFaxDecode(data, width, height);
                    dataLength = data.length;
                }
                catch (Throwable e) {
                    logger.finer("Failed to do secondary load attempt with ccittFax");
                }
            }
            try {
                decodedImage = ImageUtility.makeImageWithRasterFromBytes(colourSpace, graphicsState, width, height, colorSpaceCompCount, bitsPerComponent, isImageMask, decode, sMaskImage, maskImage, maskMinRGB, maskMaxRGB, maskMinIndex, maskMaxIndex, data, dataLength);
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error building image raster.", e);
                if (forceJAI) break block19;
                decodedImage = this.ccittFaxDecode(colourSpace, graphicsState, width, height, colorSpaceCompCount, bitsPerComponent, isImageMask, decode, sMaskImage, maskImage, maskMinRGB, maskMaxRGB, maskMinIndex, maskMaxIndex, true);
            }
        }
        return decodedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage dctDecode(int width, int height, PColorSpace colourSpace, int bitspercomponent, float[] decode) {
        ByteArrayInputStream input = this.getDecodedByteArrayInputStream();
        int MAX_BYTES_TO_READ_FOR_ENCODING = 2048;
        BufferedInputStream bufferedInput = new BufferedInputStream(input, 2048);
        bufferedInput.mark(2048);
        BufferedImage tmpImage = null;
        ImageReader reader = null;
        ImageInputStream imageInputStream = null;
        try {
            byte[] data = this.getDecodedStreamBytes(width * height * colourSpace.getNumComponents() * bitspercomponent / 8);
            int dataRead = data.length;
            if (dataRead > 2048) {
                dataRead = 2048;
            }
            int jpegEncoding = ImageUtility.getJPEGEncoding(data, dataRead);
            imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
            Iterator<ImageReader> iter = ImageIO.getImageReaders(imageInputStream);
            while (iter.hasNext()) {
                reader = iter.next();
                if (!reader.canReadRaster()) continue;
                if (!logger.isLoggable(Level.FINER)) break;
                logger.finer("DCTDecode Image reader: " + reader + " " + width + "x" + height);
                break;
            }
            if (reader == null) {
                imageInputStream.close();
                BufferedImage bufferedImage = null;
                return bufferedImage;
            }
            reader.setInput(imageInputStream, true, true);
            ImageReadParam param = reader.getDefaultReadParam();
            WritableRaster wr = (WritableRaster)reader.readRaster(0, param);
            if (jpegEncoding == 1 && bitspercomponent == 8) {
                tmpImage = ImageUtility.convertSpaceToRgb(wr, colourSpace, decode);
            } else if (jpegEncoding == 2 && bitspercomponent == 8) {
                tmpImage = ImageUtility.convertCmykToRgb(wr, decode);
            } else if (jpegEncoding == 3 && bitspercomponent == 8 && !(colourSpace instanceof Indexed)) {
                tmpImage = ImageUtility.convertYCbCrToRGB(wr, decode);
            } else if (jpegEncoding == 4 && bitspercomponent == 8) {
                tmpImage = ImageUtility.convertYCCKToRgb(wr, decode);
            } else if (jpegEncoding == 5 && bitspercomponent == 8) {
                tmpImage = !(colourSpace instanceof DeviceGray || colourSpace instanceof ICCBased || colourSpace instanceof Indexed) ? (colourSpace instanceof Separation && ((Separation)colourSpace).isNamedColor() ? ImageUtility.convertGrayToRgb(wr, decode) : ImageUtility.convertSpaceToRgb(wr, colourSpace, decode)) : (colourSpace instanceof Indexed ? ImageUtility.applyIndexColourModel(wr, colourSpace, bitspercomponent) : (wr.getNumBands() == 1 ? ImageUtility.makeGrayBufferedImage(wr) : ImageUtility.convertYCbCrToRGB(wr, decode)));
            } else {
                if (colourSpace instanceof Indexed) {
                    BufferedImage bufferedImage = ImageUtility.applyIndexColourModel(wr, colourSpace, bitspercomponent);
                    return bufferedImage;
                }
                tmpImage = wr.getNumBands() == 1 ? ImageUtility.convertSpaceToRgb(wr, colourSpace, decode) : ImageUtility.convertYCbCrToRGB(wr, decode);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem loading JPEG image via ImageIO: ", e);
        }
        finally {
            try {
                ((InputStream)input).close();
                if (reader != null) {
                    reader.dispose();
                }
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Problem loading JPEG image via ImageIO: ", e);
            }
        }
        return tmpImage;
    }

    private BufferedImage jbig2Decode(int width, int height, PColorSpace colourSpace, int bitsPerComponent, float[] decode) {
        BufferedImage tmpImage;
        Object jbigGlobals;
        HashMap decodeParms = this.library.getDictionary(this.entries, DECODEPARMS_KEY);
        Stream globalsStream = null;
        if (decodeParms != null && (jbigGlobals = this.library.getObject(decodeParms, JBIG2GLOBALS_KEY)) instanceof Stream) {
            globalsStream = (Stream)jbigGlobals;
        }
        byte[] data = this.getDecodedStreamBytes(width * height * colourSpace.getNumComponents() * bitsPerComponent / 8);
        if (isLevigoJBIG2ImageReaderClass) {
            try {
                tmpImage = ImageUtility.proJbig2Decode(ImageIO.createImageInputStream(new ByteArrayInputStream(data)), decodeParms, globalsStream);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Problem loading JBIG2 image using Levigo: ", e);
                tmpImage = ImageUtility.jbig2Decode(data, decodeParms, globalsStream);
            }
        } else {
            tmpImage = ImageUtility.jbig2Decode(data, decodeParms, globalsStream);
        }
        if (colourSpace instanceof DeviceGray) {
            tmpImage = ImageUtility.applyGrayDecode(tmpImage, bitsPerComponent, decode);
        }
        return tmpImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage jpxDecode(int width, int height, PColorSpace colourSpace, int bitsPerComponent, float[] decode) {
        BufferedImage tmpImage = null;
        try {
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG2000");
            if (!iterator.hasNext()) {
                logger.info("ImageIO missing required plug-in to read JPEG 2000 images. You can download the JAI ImageIO Tools from: http://www.oracle.com/technetwork/java/current-142188.html");
                return null;
            }
            byte[] data = this.getDecodedStreamBytes(width * height * colourSpace.getNumComponents() * bitsPerComponent / 8);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
            Iterator<ImageReader> iter = ImageIO.getImageReaders(imageInputStream);
            ImageReader reader = null;
            while (iter.hasNext()) {
                reader = iter.next();
                if (!reader.canReadRaster()) continue;
                if (!logger.isLoggable(Level.FINER)) break;
                logger.finer("JPXDecode Image reader: " + reader);
                break;
            }
            if (reader == null) {
                imageInputStream.close();
                return null;
            }
            ImageReadParam param = reader.getDefaultReadParam();
            reader.setInput(imageInputStream, true, true);
            try {
                tmpImage = reader.read(0, param);
            }
            finally {
                reader.dispose();
                imageInputStream.close();
            }
            WritableRaster wr = tmpImage.getRaster();
            if (colourSpace instanceof ICCBased) {
                ICCBased iccBased = (ICCBased)colourSpace;
                try {
                    ColorSpace cs = iccBased.getColorSpace();
                    ColorConvertOp cco = new ColorConvertOp(cs, null);
                    tmpImage = ImageUtility.makeRGBBufferedImage(wr);
                    cco.filter(tmpImage, tmpImage);
                }
                catch (Throwable e) {
                    logger.warning("Error processing ICC Color profile, failing back to alternative.");
                    colourSpace = iccBased.getAlternate();
                }
            }
            if (colourSpace instanceof DeviceRGB && bitsPerComponent == 8) {
                tmpImage = ImageUtility.convertSpaceToRgb(wr, colourSpace, decode);
            } else if (colourSpace instanceof DeviceCMYK && bitsPerComponent == 8) {
                tmpImage = ImageUtility.convertCmykToRgb(wr, decode);
            } else if (colourSpace instanceof DeviceGray && bitsPerComponent == 8) {
                tmpImage = ImageUtility.makeGrayBufferedImage(wr);
            } else if (colourSpace instanceof Separation) {
                tmpImage = colourSpace instanceof Separation && ((Separation)colourSpace).isNamedColor() ? ImageUtility.convertGrayToRgb(wr, decode) : ImageUtility.convertSpaceToRgb(wr, colourSpace, decode);
            } else if (colourSpace instanceof Indexed) {
                tmpImage = ImageUtility.applyIndexColourModel(wr, colourSpace, bitsPerComponent);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem loading JPEG2000 image: ", e);
        }
        return tmpImage;
    }

    private byte[] ccittFaxDecode(byte[] streamData, int width, int height) {
        HashMap decodeParms = this.library.getDictionary(this.entries, DECODEPARMS_KEY);
        float k = this.library.getFloat(decodeParms, K_KEY);
        boolean blackIs1 = this.getBlackIs1(this.library, decodeParms);
        if (!blackIs1 && CHECK_PARENT_BLACK_IS_1) {
            blackIs1 = this.getBlackIs1(this.library, this.entries);
        }
        boolean encodedByteAlign = false;
        Object encodedByteAlignObject = this.library.getObject(decodeParms, ENCODEDBYTEALIGN_KEY);
        if (encodedByteAlignObject instanceof Boolean) {
            encodedByteAlign = (Boolean)encodedByteAlignObject;
        }
        int columns = this.library.getInt(decodeParms, COLUMNS_KEY);
        int rows = this.library.getInt(decodeParms, ROWS_KEY);
        if (columns == 0) {
            columns = width;
        }
        if (rows == 0) {
            rows = height;
        }
        int size = rows * (columns + 7 >> 3);
        byte[] decodedStreamData = new byte[size];
        CCITTFaxDecoder decoder = new CCITTFaxDecoder(1, columns, rows);
        decoder.setAlign(encodedByteAlign);
        try {
            if (k == 0.0f) {
                decoder.decodeT41D(decodedStreamData, streamData, 0, rows);
            } else if (k > 0.0f) {
                decoder.decodeT42D(decodedStreamData, streamData, 0, rows);
            } else if (k < 0.0f) {
                decoder.decodeT6(decodedStreamData, streamData, 0, rows);
            }
        }
        catch (Exception e) {
            logger.warning("Error decoding CCITTFax image k: " + k);
            decoder.decodeT6(decodedStreamData, streamData, 0, rows);
        }
        if (!blackIs1) {
            for (int i = 0; i < decodedStreamData.length; ++i) {
                decodedStreamData[i] = ~decodedStreamData[i];
            }
        }
        return decodedStreamData;
    }

    private BufferedImage parseImage(int width, int height, PColorSpace colorSpace, boolean imageMask, GraphicsState graphicsState, int bitsPerColour, float[] decode, byte[] baCCITTFaxData) {
        BitStream in;
        int[] imageBits = new int[width];
        int fillRGB = 1;
        if (graphicsState != null) {
            fillRGB = graphicsState.getFillColor().getRGB();
        }
        int colorSpaceCompCount = colorSpace.getNumComponents();
        boolean isDeviceRGB = colorSpace instanceof DeviceRGB;
        boolean isDeviceGray = colorSpace instanceof DeviceGray;
        int maxColourValue = (1 << bitsPerColour) - 1;
        int[] f = new int[colorSpaceCompCount];
        float[] ff = new float[colorSpaceCompCount];
        float imageMaskValue = decode[0];
        BufferedImage bim = ImageUtility.createTranslucentCompatibleImage(width, height);
        if (baCCITTFaxData != null) {
            in = new BitStream(new ByteArrayInputStream(baCCITTFaxData));
        } else {
            ByteArrayInputStream dataInput = this.getDecodedByteArrayInputStream();
            if (dataInput == null) {
                return null;
            }
            in = new BitStream(dataInput);
        }
        try {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (imageMask) {
                        int bit = in.getBits(bitsPerColour);
                        imageBits[x] = bit = (float)bit == imageMaskValue ? fillRGB : 0;
                        continue;
                    }
                    int red = 255;
                    int blue = 255;
                    int green = 255;
                    int alpha = 255;
                    if (colorSpaceCompCount == 1) {
                        int bit = in.getBits(bitsPerColour);
                        if (decode != null && decode[0] > decode[1]) {
                            int n = bit = bit == maxColourValue ? 0 : maxColourValue;
                        }
                        if (isDeviceGray) {
                            if (bitsPerColour == 1) {
                                bit = ImageUtility.GRAY_1_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 2) {
                                bit = ImageUtility.GRAY_2_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 4) {
                                bit = ImageUtility.GRAY_4_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 8) {
                                bit = bit << 24 | bit << 16 | bit << 8 | bit;
                            }
                            imageBits[x] = bit;
                            continue;
                        }
                        f[0] = bit;
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    if (colorSpaceCompCount == 3) {
                        if (isDeviceRGB) {
                            red = in.getBits(bitsPerColour);
                            green = in.getBits(bitsPerColour);
                            blue = in.getBits(bitsPerColour);
                            imageBits[x] = alpha << 24 | red << 16 | green << 8 | blue;
                            continue;
                        }
                        for (int i = 0; i < colorSpaceCompCount; ++i) {
                            f[i] = in.getBits(bitsPerColour);
                        }
                        PColorSpace.reverseInPlace(f);
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    if (colorSpaceCompCount == 4 || colorSpace instanceof DeviceN) {
                        for (int i = 0; i < colorSpaceCompCount; ++i) {
                            f[i] = in.getBits(bitsPerColour);
                            if (!(decode[0] > decode[1])) continue;
                            f[i] = maxColourValue - f[i];
                        }
                        PColorSpace.reverseInPlace(f);
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    imageBits[x] = alpha << 24 | red << 16 | green << 8 | blue;
                }
                bim.setRGB(0, y, width, 1, imageBits, 0, 1);
            }
            in.close();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error parsing image.", e);
        }
        return bim;
    }

    public boolean getBlackIs1(Library library, HashMap decodeParmsDictionary) {
        Object blackIs1Obj = library.getObject(decodeParmsDictionary, BLACKIS1_KEY);
        if (blackIs1Obj != null) {
            if (blackIs1Obj instanceof Boolean) {
                return (Boolean)blackIs1Obj;
            }
            if (blackIs1Obj instanceof String) {
                String blackIs1String = (String)blackIs1Obj;
                if (blackIs1String.equalsIgnoreCase("true")) {
                    return true;
                }
                if (blackIs1String.equalsIgnoreCase("t")) {
                    return true;
                }
                if (blackIs1String.equals("1")) {
                    return true;
                }
                if (blackIs1String.equalsIgnoreCase("false")) {
                    return false;
                }
                if (blackIs1String.equalsIgnoreCase("f")) {
                    return false;
                }
                if (blackIs1String.equals("0")) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean containsFilter(String[] searchFilterNames) {
        List<String> filterNames = this.getFilterNames();
        if (filterNames == null) {
            return false;
        }
        for (String filterName1 : filterNames) {
            String filterName = filterName1.toString();
            for (String search : searchFilterNames) {
                if (!search.equals(filterName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isImageMask() {
        return this.library.getBoolean(this.entries, IMAGEMASK_KEY);
    }

    private boolean shouldUseCCITTFaxDecode() {
        return this.containsFilter(CCITTFAX_DECODE_FILTERS);
    }

    private boolean shouldUseDCTDecode() {
        return this.containsFilter(DCT_DECODE_FILTERS);
    }

    private boolean shouldUseJBIG2Decode() {
        return this.containsFilter(JBIG2_DECODE_FILTERS);
    }

    private boolean shouldUseJPXDecode() {
        return this.containsFilter(JPX_DECODE_FILTERS);
    }

    public static void forceJaiCcittFax(boolean enable) {
        forceJaiccittfax = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PColorSpace getColourSpace() {
        Object object = this.colorSpaceAssignmentLock;
        synchronized (object) {
            return this.colourSpace;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Image stream= ");
        sb.append(this.entries);
        if (this.getPObjectReference() != null) {
            sb.append("  ");
            sb.append(this.getPObjectReference());
        }
        return sb.toString();
    }

    static {
        try {
            Class.forName("com.levigo.jbig2.JBIG2ImageReader");
            isLevigoJBIG2ImageReaderClass = true;
            logger.info("Levigo JBIG2 image library was found on classpath");
        }
        catch (ClassNotFoundException e) {
            logger.info("Levigo JBIG2 image library was not found on classpath");
        }
        CHECK_PARENT_BLACK_IS_1 = Defs.booleanProperty("org.icepdf.core.ccittfax.checkParentBlackIs1", false);
    }
}

