/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.ImageUtility;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.CachedImageReference;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.ImagePool;
import org.icepdf.core.pobjects.graphics.ImageReference;
import org.icepdf.core.util.Library;

public class ScaledImageReference
extends CachedImageReference {
    private static final Logger logger = Logger.getLogger(ScaledImageReference.class.toString());
    private int width;
    private int height;

    protected ScaledImageReference(ImageStream imageStream, GraphicsState graphicsState, Resources resources, int imageIndex, Page page) {
        super(imageStream, graphicsState, resources, imageIndex, page);
        this.width = imageStream.getWidth();
        this.height = imageStream.getHeight();
        ImagePool imagePool = imageStream.getLibrary().getImagePool();
        if (useProxy && imagePool.get(this.reference) == null) {
            this.futureTask = new FutureTask<BufferedImage>(this);
            Library.executeImage(this.futureTask);
        } else if (!useProxy && imagePool.get(this.reference) == null) {
            this.image = this.call();
        }
    }

    public ScaledImageReference(ImageReference imageReference, GraphicsState graphicsState, Resources resources, int width, int height, int imageIndex, Page page) {
        super(imageReference.getImageStream(), graphicsState, resources, imageIndex, page);
        this.width = width;
        this.height = height;
        if (imageReference.isImage()) {
            this.image = imageReference.getImage();
        }
        ImagePool imagePool = this.imageStream.getLibrary().getImagePool();
        if (useProxy && imagePool.get(this.reference) == null) {
            this.futureTask = new FutureTask<BufferedImage>(this);
            Library.executeImage(this.futureTask);
        } else if (!useProxy && imagePool.get(this.reference) == null) {
            this.image = this.call();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage call() {
        BufferedImage image = null;
        long start = System.nanoTime();
        try {
            image = this.imageStream.getImage(this.graphicsState, this.resources);
            if (image != null) {
                int width = this.imageStream.getWidth();
                int height = this.imageStream.getHeight();
                double scaleFactor = 1.0;
                if (width > 1000 && width < 1500) {
                    scaleFactor = 0.75;
                } else if (width > 1500) {
                    scaleFactor = 0.5;
                }
                if (scaleFactor < 1.0) {
                    width = (int)Math.ceil((double)width * scaleFactor);
                    height = (int)Math.ceil((double)height * scaleFactor);
                    BufferedImage scaled = ImageUtility.hasAlpha(image) ? ImageUtility.createTranslucentCompatibleImage(width, height) : ImageUtility.createCompatibleImage(width, height);
                    Graphics2D g = scaled.createGraphics();
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g.drawImage(image, 0, 0, width, height, null);
                    g.dispose();
                    image.flush();
                    image = scaled;
                }
            }
        }
        catch (Throwable e) {
            logger.warning("Error loading image: " + this.imageStream.getPObjectReference() + " " + this.imageStream.toString());
        }
        long end = System.nanoTime();
        this.notifyImagePageEvents(end - start);
        return image;
    }
}

