/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.component.JimiCanvas;
import com.sun.jimi.core.component.JimiImageRenderer;
import com.sun.jimi.core.component.SmartCroppingPanel;
import com.sun.jimi.core.raster.JimiRasterImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.ImageProducer;

public class SmartScrollingRenderer
extends Panel
implements JimiImageRenderer,
AdjustmentListener {
    protected JimiRasterImage rasterImage;
    protected Scrollbar vsb;
    protected Scrollbar hsb;
    protected SmartCroppingPanel cropper;
    protected JimiCanvas canvas;
    static int count = 0;

    public SmartScrollingRenderer(JimiCanvas jimiCanvas) {
        this.canvas = jimiCanvas;
        this.vsb = new Scrollbar(1, 0, 10, 0, 100);
        this.hsb = new Scrollbar(0, 0, 10, 0, 100);
        this.vsb.setUnitIncrement(10);
        this.hsb.setUnitIncrement(10);
        this.vsb.addAdjustmentListener(this);
        this.hsb.addAdjustmentListener(this);
        this.addComponentListener(new ResizeListener());
        this.cropper = new SmartCroppingPanel(jimiCanvas);
        this.setLayout(new BorderLayout());
        this.add("Center", this.cropper);
        this.add("East", this.vsb);
        this.add("South", this.hsb);
        this.vsb.setVisible(false);
        this.hsb.setVisible(false);
        this.addComponentListener(new ResizeWatcher());
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        switch (adjustmentEvent.getID()) {
            default: 
        }
        this.cropper.setPosition(this.hsb.getValue(), this.vsb.getValue());
    }

    protected void calibrateScrolling() {
        if (this.rasterImage != null) {
            int n = this.rasterImage.getWidth();
            int n2 = this.rasterImage.getHeight();
            int n3 = this.cropper.getSize().width;
            int n4 = this.cropper.getSize().height;
            if (n <= n3 && n2 <= n4) {
                this.hsb.setVisible(false);
                this.vsb.setVisible(false);
            } else {
                int n5 = n - n3;
                int n6 = n2 - n4;
                this.vsb.setValues(0, n4, 0, n2);
                this.hsb.setValues(0, n3, 0, n);
                this.vsb.setBlockIncrement(n4);
                this.vsb.setPageIncrement(n4);
                this.hsb.setBlockIncrement(n4);
                this.hsb.setPageIncrement(n4);
                this.hsb.setVisible(true);
                this.vsb.setVisible(true);
            }
            this.validate();
        }
    }

    public Component getContentPane() {
        return this;
    }

    public void render() {
        this.cropper.redraw();
    }

    public void setImage(Image image) {
        if (image == null) {
            return;
        }
        try {
            this.setRasterImage(Jimi.createRasterImage(image.getSource()));
        }
        catch (JimiException jimiException) {}
    }

    public void setImageProducer(ImageProducer imageProducer) {
        if (imageProducer == null) {
            return;
        }
        try {
            this.setRasterImage(Jimi.createRasterImage(imageProducer));
        }
        catch (JimiException jimiException) {}
    }

    public void setRasterImage(JimiRasterImage jimiRasterImage) {
        if (jimiRasterImage == null) {
            return;
        }
        jimiRasterImage.waitFinished();
        this.rasterImage = jimiRasterImage;
        this.cropper.setImage(jimiRasterImage);
        this.calibrateScrolling();
    }

    class ResizeListener
    extends ComponentAdapter {
        ResizeListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            SmartScrollingRenderer.this.calibrateScrolling();
        }
    }

    class ResizeWatcher
    extends ComponentAdapter {
        ResizeWatcher() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            SmartScrollingRenderer.this.calibrateScrolling();
        }
    }
}

