/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.ico;

import com.sun.jimi.core.decoder.ico.BitmapInfoHeader;
import com.sun.jimi.core.decoder.ico.RGBQuad;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class IconImage {
    private static final boolean DEBUG = false;
    private BitmapInfoHeader header_;
    private RGBQuad[] colors_;
    private byte[] xorMap_;
    private byte[] andMap_;

    public IconImage(LEDataInputStream lEDataInputStream) throws IOException {
        try {
            byte by;
            int n;
            int n2;
            this.header_ = new BitmapInfoHeader(lEDataInputStream);
            int n3 = (int)Math.pow(2.0, this.getBitCount());
            this.colors_ = new RGBQuad[n3];
            int n4 = 0;
            while (n4 < this.colors_.length) {
                this.colors_[n4] = new RGBQuad(lEDataInputStream);
                ++n4;
            }
            int n5 = (int)(this.header_.getWidth() * this.header_.getHeight() / 2L);
            this.xorMap_ = new byte[n5];
            byte[] byArray = new byte[n5 / (8 / this.getBitCount())];
            int n6 = 0;
            while (n6 < byArray.length) {
                byArray[n6] = n2 = (int)((byte)lEDataInputStream.readUnsignedByte());
                ++n6;
            }
            n2 = this.getBitCount();
            switch (n2) {
                case 1: {
                    n = 0;
                    by = 0;
                    while (n < byArray.length) {
                        this.xorMap_[by] = (byte)((byArray[n] & 0x80) >>> 7);
                        this.xorMap_[by + 1] = (byte)((byArray[n] & 0x40) >>> 6);
                        this.xorMap_[by + 2] = (byte)((byArray[n] & 0x20) >>> 5);
                        this.xorMap_[by + 3] = (byte)((byArray[n] & 0x10) >>> 4);
                        this.xorMap_[by + 4] = (byte)((byArray[n] & 8) >>> 3);
                        this.xorMap_[by + 5] = (byte)((byArray[n] & 4) >>> 2);
                        this.xorMap_[by + 6] = (byte)((byArray[n] & 2) >>> 1);
                        this.xorMap_[by + 7] = (byte)(byArray[n] & 1);
                        ++n;
                        by = (byte)(by + 8);
                    }
                    break;
                }
                case 3: {
                    n = 0;
                    by = 0;
                    while (n < byArray.length) {
                        this.xorMap_[by] = (byte)((byArray[n] & 0xC0) >>> 6);
                        this.xorMap_[by + 1] = (byte)((byArray[n] & 0x30) >>> 4);
                        this.xorMap_[by + 2] = (byte)((byArray[n] & 0xC) >>> 2);
                        this.xorMap_[by + 3] = (byte)(byArray[n] & 3);
                        ++n;
                        by = (byte)(by + 4);
                    }
                    break;
                }
                case 4: {
                    n = 0;
                    by = 0;
                    while (n < byArray.length) {
                        this.xorMap_[by] = (byte)((byArray[n] & 0xF0) >>> 4);
                        this.xorMap_[by + 1] = (byte)(byArray[n] & 0xF);
                        ++n;
                        by = (byte)(by + 2);
                    }
                    break;
                }
                case 8: {
                    this.xorMap_ = byArray;
                    break;
                }
            }
            this.andMap_ = new byte[n5 / 8];
            n = 0;
            while (n < this.andMap_.length) {
                this.andMap_[n] = by = (byte)lEDataInputStream.readUnsignedByte();
                ++n;
            }
        }
        catch (Exception exception) {}
    }

    public byte[] getANDMap() {
        return this.andMap_;
    }

    public int getBitCount() {
        return this.header_.getBitCount();
    }

    public RGBQuad[] getColors() {
        return this.colors_;
    }

    public int getHeight() {
        return (int)this.header_.getHeight() / 2;
    }

    public int getWidth() {
        return (int)this.header_.getWidth();
    }

    public byte[] getXORMap() {
        return this.xorMap_;
    }
}

