/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.math.pdf;

public class PDF {
    private static int lgfN = 6;
    private static double[] lgfCoeff = new double[]{1.000000000190015, 76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static double lgfGamma = 5.0;
    private static int igfiter = 1000;
    private static double igfeps = 1.0E-8;
    public static final double FPMIN = 1.0E-300;

    public static double betaCDF(double alpha, double beta, double limit) {
        return PDF.betaCDF(0.0, 1.0, alpha, beta, limit);
    }

    public static double betaCDF(double min, double max, double alpha, double beta, double limit) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + alpha + "must be greater than zero");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + beta + "must be greater than zero");
        }
        if (limit < min) {
            throw new IllegalArgumentException("limit, " + limit + ", must be greater than or equal to the minimum value, " + min);
        }
        if (limit > max) {
            throw new IllegalArgumentException("limit, " + limit + ", must be less than or equal to the maximum value, " + max);
        }
        return PDF.regularisedBetaFunction(alpha, beta, (limit - min) / (max - min));
    }

    public static double betaFunction(double z, double w) {
        return Math.exp(PDF.logGamma(z) + PDF.logGamma(w) - PDF.logGamma(z + w));
    }

    public static double betaPDF(double alpha, double beta, double x) {
        return PDF.betaPDF(0.0, 1.0, alpha, beta, x);
    }

    public static double betaPDF(double min, double max, double alpha, double beta, double x) {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, alpha, " + alpha + "must be greater than zero");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, beta, " + beta + "must be greater than zero");
        }
        if (x < min) {
            throw new IllegalArgumentException("x, " + x + ", must be greater than or equal to the minimum value, " + min);
        }
        if (x > max) {
            throw new IllegalArgumentException("x, " + x + ", must be less than or equal to the maximum value, " + max);
        }
        double pdf = Math.pow(x - min, alpha - 1.0) * Math.pow(max - x, beta - 1.0) / Math.pow(max - min, alpha + beta - 1.0);
        return pdf / PDF.betaFunction(alpha, beta);
    }

    public static double binomial(double p, int n, int k) {
        if (k < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (k > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return Math.floor(0.5 + Math.exp(PDF.logFactorial(n) - PDF.logFactorial(k) - PDF.logFactorial(n - k))) * Math.pow(p, k) * Math.pow(1.0 - p, n - k);
    }

    public static double binomialCDF(double p, int n, int k) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("\np must lie between 0 and 1");
        }
        if (k < 0 || n < 0) {
            throw new IllegalArgumentException("\nn and k must be greater than or equal to zero");
        }
        if (k > n) {
            throw new IllegalArgumentException("\nk is greater than n");
        }
        return PDF.regularisedBetaFunction(k, n - k + 1, p);
    }

    public static double chiSquare(double chiSquare, int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        double dnu = nu;
        return Math.pow(0.5, dnu / 2.0) * Math.pow(chiSquare, dnu / 2.0 - 1.0) * Math.exp(-chiSquare / 2.0) / PDF.gammaFunction(dnu / 2.0);
    }

    public static double chiSquareCDF(double chiSquare, int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        return PDF.regularisedGammaFunction((double)nu / 2.0, chiSquare / 2.0);
    }

    public static double complementaryRegularisedGammaFunction(double a, double x) {
        if (a < 0.0 || x < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        double igf = 0.0;
        if (x != 0.0) {
            igf = x == Double.POSITIVE_INFINITY ? 1.0 : (x < a + 1.0 ? 1.0 - PDF.incompleteGammaSer(a, x) : 1.0 - PDF.incompleteGammaFract(a, x));
        }
        return igf;
    }

    public static double contFract(double a, double b, double x) {
        int maxit = 500;
        double eps = 3.0E-7;
        double aplusb = a + b;
        double aplus1 = a + 1.0;
        double aminus1 = a - 1.0;
        double c = 1.0;
        double d = 1.0 - aplusb * x / aplus1;
        if (Math.abs(d) < 1.0E-300) {
            d = 1.0E-300;
        }
        double h = d = 1.0 / d;
        double aa = 0.0;
        double del = 0.0;
        int i = 1;
        int i2 = 0;
        boolean test = true;
        while (test) {
            i2 = 2 * i;
            aa = (double)i * (b - (double)i) * x / ((aminus1 + (double)i2) * (a + (double)i2));
            if (Math.abs(d = 1.0 + aa * d) < 1.0E-300) {
                d = 1.0E-300;
            }
            if (Math.abs(c = 1.0 + aa / c) < 1.0E-300) {
                c = 1.0E-300;
            }
            d = 1.0 / d;
            h *= d * c;
            aa = -(a + (double)i) * (aplusb + (double)i) * x / ((a + (double)i2) * (aplus1 + (double)i2));
            if (Math.abs(d = 1.0 + aa * d) < 1.0E-300) {
                d = 1.0E-300;
            }
            if (Math.abs(c = 1.0 + aa / c) < 1.0E-300) {
                c = 1.0E-300;
            }
            d = 1.0 / d;
            del = d * c;
            h *= del;
            ++i;
            if (Math.abs(del - 1.0) < 3.0E-7) {
                test = false;
            }
            if (i <= 500) continue;
            test = false;
        }
        return h;
    }

    public static double cosh(double a) {
        return 0.5 * (Math.exp(a) + Math.exp(-a));
    }

    public static double erf(double x) {
        double erf = 0.0;
        if (x != 0.0) {
            erf = x == Double.POSITIVE_INFINITY ? 1.0 : (x >= 0.0 ? PDF.regularisedGammaFunction(0.5, x * x) : -PDF.regularisedGammaFunction(0.5, x * x));
        }
        return erf;
    }

    public static double exponential(double mu, double sigma, double x) {
        double arg = (x - mu) / sigma;
        double y = 0.0;
        if (arg >= 0.0) {
            y = Math.exp(-arg) / sigma;
        }
        return y;
    }

    public static double exponentialCDF(double mu, double sigma, double upperlimit) {
        double arg = (upperlimit - mu) / sigma;
        double y = 0.0;
        if (arg > 0.0) {
            y = 1.0 - Math.exp(-arg);
        }
        return y;
    }

    public static double factorial(double n) {
        if (n < 0.0 || n - Math.floor(n) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f = 1.0;
        int i = 1;
        while ((double)i <= n) {
            f *= (double)i;
            ++i;
        }
        return f;
    }

    public static double gamma(double gamma, double x) {
        if (x < 0.0) {
            throw new IllegalArgumentException("The variable, x, " + x + "must be equal to or greater than zero");
        }
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + gamma + "must be greater than zero");
        }
        return Math.pow(x, gamma - 1.0) * Math.exp(-x) / PDF.gammaFunction(gamma);
    }

    public static double gammaCDF(double gamma, double upperLimit) {
        if (upperLimit < 0.0) {
            throw new IllegalArgumentException("The upper limit, " + upperLimit + "must be equal to or greater than zero");
        }
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("The shape parameter, " + gamma + "must be greater than zero");
        }
        return PDF.regularisedGammaFunction(gamma, upperLimit);
    }

    public static double gammaFunction(double x) {
        double xcopy = x;
        double first = x + lgfGamma + 0.5;
        double second = lgfCoeff[0];
        double fg = 0.0;
        if (x >= 0.0) {
            if (x >= 1.0 && x - (double)((int)x) == 0.0) {
                fg = PDF.factorial(x) / x;
            } else {
                first = Math.pow(first, x + 0.5) * Math.exp(-first);
                for (int i = 1; i <= lgfN; ++i) {
                    second += lgfCoeff[i] / (xcopy += 1.0);
                }
                fg = first * Math.sqrt(Math.PI * 2) * second / x;
            }
        } else {
            fg = -Math.PI / (x * PDF.gammaFunction(-x) * Math.sin(Math.PI * x));
        }
        return fg;
    }

    public static double incompleteGammaFract(double a, double x) {
        if (a < 0.0 || x < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        if (x < a + 1.0) {
            throw new IllegalArgumentException("\nx < a+1   Use Series Representation");
        }
        int i = 0;
        double ii = 0.0;
        double igf = 0.0;
        boolean check = true;
        double loggamma = PDF.logGamma(a);
        double numer = 0.0;
        double incr = 0.0;
        double denom = x - a + 1.0;
        double first = 1.0 / denom;
        double term = 9.999999999999999E299;
        double prod = first;
        while (check) {
            if (Math.abs(first = (numer = -(ii = (double)(++i)) * (ii - a)) * first + (denom += 2.0)) < 1.0E-300) {
                first = 1.0E-300;
            }
            if (Math.abs(term = denom + numer / term) < 1.0E-300) {
                term = 1.0E-300;
            }
            first = 1.0 / first;
            incr = first * term;
            prod *= incr;
            if (Math.abs(incr - 1.0) < igfeps) {
                check = false;
            }
            if (i < igfiter) continue;
            check = false;
        }
        igf = 1.0 - Math.exp(-x + a * Math.log(x) - loggamma) * prod;
        return igf;
    }

    public static double incompleteGammaSer(double a, double x) {
        double sum;
        if (a < 0.0 || x < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        if (x >= a + 1.0) {
            throw new IllegalArgumentException("\nx >= a+1   use Continued Fraction Representation");
        }
        int i = 0;
        double igf = 0.0;
        boolean check = true;
        double acopy = a;
        double incr = sum = 1.0 / a;
        double loggamma = PDF.logGamma(a);
        while (check) {
            ++i;
            sum += (incr *= x / (a += 1.0));
            if (Math.abs(incr) < Math.abs(sum) * igfeps) {
                igf = sum * Math.exp(-x + acopy * Math.log(x) - loggamma);
                check = false;
            }
            if (i < igfiter) continue;
            check = false;
            igf = sum * Math.exp(-x + acopy * Math.log(x) - loggamma);
        }
        return igf;
    }

    public static double logFactorial(double n) {
        if (n < 0.0 || n - Math.floor(n) != 0.0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f = 0.0;
        for (double iCount = 2.0; iCount <= n; iCount += 1.0) {
            f += Math.log(iCount);
        }
        return f;
    }

    public static double logFactorial(int n) {
        if (n < 0 || n - n != 0) {
            throw new IllegalArgumentException("\nn must be a positive integer\nIs a Gamma funtion [Fmath.gamma(x)] more appropriate?");
        }
        double f = 0.0;
        for (int i = 2; i <= n; ++i) {
            f += Math.log(i);
        }
        return f;
    }

    public static double logGamma(double x) {
        double xcopy = x;
        double fg = 0.0;
        double first = x + lgfGamma + 0.5;
        double second = lgfCoeff[0];
        if (x >= 0.0) {
            if (x >= 1.0 && x - (double)((int)x) == 0.0) {
                fg = PDF.logFactorial(x) - Math.log(x);
            } else {
                first -= (x + 0.5) * Math.log(first);
                for (int i = 1; i <= lgfN; ++i) {
                    second += lgfCoeff[i] / (xcopy += 1.0);
                }
                fg = Math.log(Math.sqrt(Math.PI * 2) * second / x) - first;
            }
        } else {
            fg = Math.PI / (PDF.gammaFunction(1.0 - x) * Math.sin(Math.PI * x));
            if (fg != Double.POSITIVE_INFINITY && fg != Double.NEGATIVE_INFINITY) {
                if (fg < 0.0) {
                    throw new IllegalArgumentException("\nThe gamma function is negative");
                }
                fg = Math.log(fg);
            }
        }
        return fg;
    }

    public static double logistic(double mu, double beta, double x) {
        return PDF.square(PDF.sech((x - mu) / (2.0 * beta))) / (4.0 * beta);
    }

    public static double logisticCDF(double mu, double beta, double upperlimit) {
        return 0.5 * (1.0 + PDF.tanh((upperlimit - mu) / (2.0 * beta)));
    }

    public static double lorentzian(double mu, double gamma, double x) {
        double arg = gamma / 2.0;
        return 0.3183098861837907 * arg / (PDF.square(mu - x) + arg * arg);
    }

    public static double lorentzianCDF(double mu, double gamma, double upperlimit) {
        double arg = (upperlimit - mu) / (gamma / 2.0);
        return 0.3183098861837907 * (Math.atan(arg) + 1.5707963267948966);
    }

    public static double normal(double mean, double sd, double x) {
        return Math.exp(-PDF.square((x - mean) / sd) / 2.0) / (sd * Math.sqrt(Math.PI * 2));
    }

    public static double normalCDF(double mean, double sd, double upperlimit) {
        double arg = (upperlimit - mean) / (sd * Math.sqrt(2.0));
        return (1.0 + PDF.erf(arg)) / 2.0;
    }

    public static double poisson(int k, double mean) {
        if (k < 0) {
            throw new IllegalArgumentException("k must be an integer greater than or equal to 0");
        }
        return Math.pow(mean, k) * Math.exp(-mean) / PDF.factorial(k);
    }

    public static double poissonCDF(int k, double mean) {
        if (k < 1) {
            throw new IllegalArgumentException("k must be an integer greater than or equal to 1");
        }
        return PDF.complementaryRegularisedGammaFunction(k, mean);
    }

    public static double regularisedBetaFunction(double z, double w, double x) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("Argument x, " + x + ", must be lie between 0 and 1 (inclusive)");
        }
        double ibeta = 0.0;
        if (x == 0.0) {
            ibeta = 0.0;
        } else if (x == 1.0) {
            ibeta = 1.0;
        } else {
            ibeta = Math.exp(PDF.logGamma(z + w) - PDF.logGamma(z) - PDF.logGamma(w) + z * Math.log(x) + w * Math.log(1.0 - x));
            ibeta = x < (z + 1.0) / (z + w + 2.0) ? ibeta * PDF.contFract(z, w, x) / z : 1.0 - ibeta * PDF.contFract(w, z, 1.0 - x) / w;
        }
        return ibeta;
    }

    public static double regularisedGammaFunction(double a, double x) {
        if (a < 0.0 || x < 0.0) {
            throw new IllegalArgumentException("\nFunction defined only for a >= 0 and x>=0");
        }
        double igf = 0.0;
        igf = x < a + 1.0 ? PDF.incompleteGammaSer(a, x) : PDF.incompleteGammaFract(a, x);
        return igf;
    }

    public static double sech(double a) {
        return 1.0 / PDF.cosh(a);
    }

    public static double sign(double x) {
        if (x < 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static double sinh(double a) {
        return 0.5 * (Math.exp(a) - Math.exp(-a));
    }

    public static double square(double a) {
        return a * a;
    }

    public static double studentT(double tValue, int df) {
        double ddf = df;
        double dfterm = (ddf + 1.0) / 2.0;
        return PDF.gammaFunction(dfterm) / PDF.gammaFunction(ddf / 2.0) / Math.sqrt(ddf * Math.PI) * Math.pow(1.0 + tValue * tValue / ddf, -dfterm);
    }

    public static double studentTCDF(double tValue, int df) {
        double ddf = df;
        double x = ddf / (ddf + tValue * tValue);
        return 0.5 * (1.0 + (PDF.regularisedBetaFunction(ddf / 2.0, 0.5, 1.0) - PDF.regularisedBetaFunction(ddf / 2.0, 0.5, x)) * PDF.sign(tValue));
    }

    public static double tanh(double a) {
        return PDF.sinh(a) / PDF.cosh(a);
    }

    public static double weibull(double mu, double sigma, double gamma, double x) {
        double arg = (x - mu) / sigma;
        double y = 0.0;
        if (arg >= 0.0) {
            y = gamma / sigma * Math.pow(arg, gamma - 1.0) * Math.exp(-Math.pow(arg, gamma));
        }
        return y;
    }

    public static double weibullCDF(double mu, double sigma, double gamma, double upperlimit) {
        double arg = (upperlimit - mu) / sigma;
        double y = 0.0;
        if (arg > 0.0) {
            y = 1.0 - Math.exp(-Math.pow(arg, gamma));
        }
        return y;
    }
}

