/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.date;

import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;

public class RelativeIntervalFunction
extends AbstractFunction {
    private final Coercion toInstant = ToolsLocator.getDataTypesManager().getCoercion(68);

    public RelativeIntervalFunction() {
        super("Date", "RelativeInterval", Range.is((Comparable)Integer.valueOf(2)), "Returns a relative interval from the arguments", "RelativeInterval({{date1}}, data2)", new String[]{"date1 - An object that represents a moment of time.", "date2 - An object that represents a moment of time."}, "RelativeInterval", false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        Object arg0 = this.getObject(args, 0);
        Object arg1 = this.getObject(args, 1);
        try {
            RelativeInstant instant0 = (RelativeInstant)this.toInstant.coerce(arg0);
            RelativeInstant instant1 = (RelativeInstant)this.toInstant.coerce(arg1);
            RelativeInterval interval = TimeSupportLocator.getManager().createRelativeInterval(instant0, instant1);
            return interval;
        }
        catch (CoercionException ex) {
            throw new RuntimeException("Can't create an interval from '" + Objects.toString(arg0, "") + ":" + Objects.toString(arg1, "") + "'.", ex);
        }
    }
}

