/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.common;

import com.jeta.forms.gui.common.FormException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class URLClassLoaderHelper {
    private ArrayList m_url_list = new ArrayList();
    private URL[] m_urls;
    private URLClassLoader m_url_loader;

    public URLClassLoaderHelper() {
    }

    public URLClassLoaderHelper(Collection urls) {
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            this.addUrl((URL)iter.next());
        }
    }

    public void addUrl(URL url) {
        this.m_url_list.add(url);
        this.m_urls = null;
        this.m_url_loader = null;
    }

    public ClassLoader getClassLoader() throws FormException {
        if (this.m_urls == null) {
            this.m_urls = this.m_url_list.toArray(new URL[0]);
        }
        if (this.m_urls.length > 0 && this.m_url_loader == null) {
            this.m_url_loader = new URLClassLoader(this.m_urls);
        }
        return this.m_url_loader;
    }

    public Class getClass(String className) throws FormException {
        try {
            this.getClassLoader();
            if (this.m_urls.length == 0) {
                Class<?> c = Class.forName(className);
                return c;
            }
            ClassLoader loader = this.getClassLoader();
            Class<?> c = loader.loadClass(className);
            return c;
        }
        catch (Exception e) {
            if (e instanceof FormException) {
                throw (FormException)e;
            }
            throw new FormException(e);
        }
    }

    public Object createObject(String beanName) throws FormException {
        try {
            Class c = this.getClass(beanName);
            return c.newInstance();
        }
        catch (Exception e) {
            if (e instanceof FormException) {
                throw (FormException)e;
            }
            throw new FormException(e);
        }
    }

    public void print() {
        try {
            this.getClassLoader();
            System.out.println("URLClassLoaderHelper  m_urls.length = " + this.m_urls.length);
            for (int index = 0; index < this.m_urls.length; ++index) {
                System.out.println(" url: " + this.m_urls[index]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

