/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import java.util.Iterator;

public class CellAssignmentCache {
    private GridView m_view;
    private CellAssignment[][] m_grid;

    public CellAssignmentCache(GridView view) {
        this.m_view = view;
    }

    void addComponent(GridComponent gc) {
        this.checkGrid();
        if (gc == null) {
            FormUtils.safeAssert(false);
            return;
        }
        CellAssignment ca = this.m_grid[gc.getRow() - 1][gc.getColumn() - 1];
        if (ca == null) {
            ca = new CellAssignment();
            ca.m_comp = gc;
            this.m_grid[gc.getRow() - 1][gc.getColumn() - 1] = ca;
        } else {
            ca.m_comp = gc;
        }
        int rowstart = gc.getRow();
        int colstart = gc.getColumn();
        int rowspan = gc.getRowSpan();
        int colspan = gc.getColumnSpan();
        if (rowspan > 1 || colspan > 1) {
            for (int row = rowstart; row <= rowstart + rowspan - 1; ++row) {
                for (int col = colstart; col <= colstart + colspan - 1; ++col) {
                    if (row == rowstart && col == colstart) continue;
                    CellAssignment ova = this.m_grid[row - 1][col - 1];
                    if (ova == null) {
                        this.m_grid[row - 1][col - 1] = ova = new CellAssignment();
                    }
                    ova.m_overlap = gc;
                }
            }
        }
    }

    private void checkGrid() {
        int columncount = this.m_view.getColumnCount();
        int rowcount = this.m_view.getRowCount();
        if (this.m_grid == null || this.m_grid[0].length != columncount || this.m_grid.length != rowcount) {
            this.resync();
        }
    }

    public GridComponent getGridComponent(int col, int row) {
        this.checkGrid();
        try {
            CellAssignment ca = this.m_grid[row - 1][col - 1];
            if (ca == null) {
                return null;
            }
            return ca.m_comp;
        }
        catch (Exception e) {
            this.resync();
            return null;
        }
    }

    public GridComponent getOverlappingComponent(int col, int row) {
        this.checkGrid();
        CellAssignment ca = this.m_grid[row - 1][col - 1];
        FormUtils.safeAssert(ca != null);
        FormUtils.safeAssert(ca.m_comp.getRow() == row);
        FormUtils.safeAssert(ca.m_comp.getColumn() == col);
        if (ca != null) {
            return ca.m_overlap;
        }
        return null;
    }

    void sync() {
        this.m_grid = null;
    }

    private void resync() {
        int columncount = this.m_view.getColumnCount();
        int rowcount = this.m_view.getRowCount();
        if (this.m_grid == null || this.m_grid[0].length != columncount || this.m_grid.length != rowcount) {
            this.m_grid = new CellAssignment[rowcount][columncount];
        } else {
            for (int row = 0; row < rowcount; ++row) {
                for (int col = 0; col < columncount; ++col) {
                    this.m_grid[row][col] = null;
                }
            }
        }
        Iterator iter = this.m_view.gridIterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof GridComponent)) continue;
            GridComponent gc = (GridComponent)obj;
            if (gc.getColumn() > columncount || gc.getRow() > rowcount) {
                FormUtils.safeAssert(false);
            }
            this.addComponent(gc);
        }
    }

    private static class CellAssignment {
        GridComponent m_comp;
        GridComponent m_overlap;

        private CellAssignment() {
        }
    }
}

