/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.bean;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.JETABeanFactory;
import com.jeta.forms.gui.beans.JETAPropertyDescriptor;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.bean.BeanSerializer;
import com.jeta.forms.store.memento.PropertiesMemento;
import com.jeta.forms.store.properties.ColorHolder;
import com.jeta.forms.store.properties.FontProperty;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.TransformOptionsProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class DefaultBeanSerializer
implements BeanSerializer {
    private static HashMap m_default_beans = new HashMap();
    private static LookAndFeel m_look_and_feel = null;
    private static HashSet m_supported_properties = new HashSet();

    private boolean areDifferent(Object def_value, Object prop_value) {
        boolean bresult = true;
        if (def_value != null) {
            if (prop_value != null) {
                bresult = def_value != prop_value && !def_value.equals(prop_value) && !prop_value.equals(def_value);
            }
        } else {
            bresult = prop_value == null ? false : prop_value != def_value && !prop_value.equals(def_value);
        }
        return bresult;
    }

    private JETABean getDefaultBean(Class compClass) {
        JETABean jbean;
        if (DefaultBeanSerializer.isLookAndFeelChanged()) {
            m_default_beans.clear();
        }
        if ((jbean = (JETABean)m_default_beans.get(compClass)) == null) {
            try {
                jbean = JETABeanFactory.createBean(compClass.getName(), null, true, false);
                if (jbean == null) {
                    Component comp = (Component)compClass.newInstance();
                    jbean = new JETABean(comp);
                }
                m_default_beans.put(compClass, jbean);
            }
            catch (Exception e) {
                FormsLogger.severe(e);
            }
        }
        return jbean;
    }

    private static boolean isLookAndFeelChanged() {
        LookAndFeel lf = UIManager.getLookAndFeel();
        if (m_look_and_feel != lf) {
            m_look_and_feel = lf;
            return true;
        }
        return false;
    }

    protected boolean isPropertySerializable(Object value) {
        if (value == null) {
            return true;
        }
        Class<?> c = value.getClass();
        if (c.isPrimitive()) {
            return true;
        }
        if (value instanceof JETAProperty) {
            JETAProperty jp = (JETAProperty)value;
            if (jp instanceof TransformOptionsProperty) {
                return true;
            }
            return !jp.isTransient();
        }
        if (m_supported_properties.contains(c)) {
            return true;
        }
        return value instanceof Color || value instanceof Font || value instanceof String || value instanceof Calendar || value instanceof Date;
    }

    public PropertiesMemento writeBean(JETABean jbean) throws FormException {
        try {
            Object[] read_params = new Object[]{};
            PropertiesMemento ppm = new PropertiesMemento();
            Component comp = jbean.getDelegate();
            if (comp != null) {
                ppm.setBeanClassName(comp.getClass().getName());
                JETABean default_bean = this.getDefaultBean(comp.getClass());
                if (default_bean != null) {
                    Collection prop_descriptors = jbean.getPropertyDescriptors();
                    Iterator iter = prop_descriptors.iterator();
                    while (iter.hasNext()) {
                        JETAPropertyDescriptor jpd = (JETAPropertyDescriptor)iter.next();
                        try {
                            Object prop_value;
                            Object def_value = jpd.getPropertyValue(default_bean);
                            if (!this.areDifferent(def_value, prop_value = jpd.getPropertyValue(jbean)) || !this.isPropertySerializable(prop_value) || !(prop_value instanceof Serializable)) continue;
                            if (prop_value instanceof Font) {
                                ppm.addProperty(jpd.getName(), new FontProperty((Font)prop_value));
                                continue;
                            }
                            if (prop_value instanceof Color) {
                                ppm.addProperty(jpd.getName(), new ColorHolder((Color)prop_value));
                                continue;
                            }
                            if (prop_value instanceof TransformOptionsProperty) {
                                ppm.addProperty(jpd.getName(), new Integer(((TransformOptionsProperty)prop_value).getPropertyValue()));
                                continue;
                            }
                            ppm.addProperty(jpd.getName(), (Serializable)prop_value);
                        }
                        catch (Exception e) {
                            FormsLogger.severe(e);
                        }
                    }
                    try {
                        ppm.addProperty("name", (Serializable)((Object)comp.getName()));
                    }
                    catch (Exception e) {
                        FormsLogger.severe(e);
                    }
                }
            }
            return ppm;
        }
        catch (Exception e) {
            if (e instanceof FormException) {
                throw (FormException)e;
            }
            throw new FormException(e);
        }
    }

    public void writeBean(OutputStream ostream, JETABean jbean) throws FormException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(ostream);
            oos.writeObject(this.writeBean(jbean));
        }
        catch (Exception e) {
            if (e instanceof FormException) {
                throw (FormException)e;
            }
            throw new FormException(e);
        }
    }

    static {
        m_supported_properties.add(Color.class);
        m_supported_properties.add(Font.class);
        m_supported_properties.add(String.class);
        m_supported_properties.add(Calendar.class);
        m_supported_properties.add(Date.class);
        m_supported_properties.add(Boolean.class);
        m_supported_properties.add(Byte.class);
        m_supported_properties.add(Character.class);
        m_supported_properties.add(Short.class);
        m_supported_properties.add(Integer.class);
        m_supported_properties.add(Long.class);
        m_supported_properties.add(Float.class);
        m_supported_properties.add(Double.class);
    }
}

