/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.jml;

import com.jeta.forms.store.jml.JMLException;
import com.jeta.forms.store.jml.JMLSerializer;
import com.jeta.forms.store.jml.JMLUtils;
import com.jeta.forms.store.jml.dom.JMLDocument;
import com.jeta.forms.store.jml.dom.JMLNode;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class JMLBeanSerializer
implements JMLSerializer {
    public JMLNode serialize(JMLDocument document, Object obj) throws JMLException {
        try {
            JMLNode objnode = JMLUtils.createObjectNode(document, obj.getClass().getName());
            if (obj != null) {
                JMLNode propsnode = JMLUtils.createPropertiesNode(document);
                objnode.appendChild(propsnode);
                BeanInfo info = Introspector.getBeanInfo(obj.getClass());
                PropertyDescriptor[] props = info.getPropertyDescriptors();
                Object[] params = new Object[]{};
                for (int index = 0; index < props.length; ++index) {
                    String pname = "";
                    try {
                        PropertyDescriptor prop = props[index];
                        pname = prop.getName();
                        Method m = prop.getReadMethod();
                        Object pvalue = m.invoke(obj, params);
                        System.out.println("XMLBeanSerializer:  pname: " + pname + "   pvalue: " + pvalue);
                        JMLNode pnode = JMLUtils.createPropertyNode(document, pname, pvalue);
                        if (pnode == null) continue;
                        propsnode.appendChild(pnode);
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage() + ".  Unable to get property: " + pname + " for bean: " + obj.getClass());
                    }
                }
            }
            return objnode;
        }
        catch (Exception e) {
            throw new JMLException(e.getMessage());
        }
    }
}

