/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.components.ContainedFormFactory;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.memento.FormMemento;
import com.jeta.forms.store.memento.StateRequest;
import com.jeta.forms.store.properties.IconProperty;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.open.registry.JETARegistry;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class TabProperty
extends JETAProperty {
    static final long serialVersionUID = 2375434406561274626L;
    public static final int VERSION = 1;
    private String m_title;
    private IconProperty m_icon_property;
    private transient FormComponent m_form;
    private FormMemento m_memento;
    public static final String PROPERTY_ID = "tab";

    public TabProperty() {
        super(PROPERTY_ID);
    }

    public TabProperty(String title) {
        super(PROPERTY_ID);
        this.m_title = title;
    }

    public FormComponent getForm() throws FormException {
        if (this.m_form == null) {
            ContainedFormFactory factory = (ContainedFormFactory)JETARegistry.lookup("contained.form.factory");
            FormUtils.safeAssert(factory != null);
            this.m_form = factory.createContainedForm(JTabbedPane.class, this.m_memento);
        }
        return this.m_form;
    }

    public FormMemento getFormMemento() throws FormException {
        if (this.m_form != null) {
            return this.m_form.getExternalState(StateRequest.DEEP_COPY);
        }
        return this.m_memento;
    }

    public String getTitle() {
        return this.m_title;
    }

    public IconProperty getIconProperty() {
        return this.m_icon_property;
    }

    public Icon icon() {
        return this.m_icon_property;
    }

    public void setIconProperty(IconProperty iprop) {
        if (this.m_icon_property == null) {
            this.m_icon_property = new IconProperty();
        }
        this.m_icon_property.setValue(iprop);
    }

    public void setValue(Object prop) {
        if (prop instanceof TabProperty) {
            TabProperty tp = (TabProperty)prop;
            this.m_title = tp.m_title;
            this.m_form = tp.m_form;
            this.m_memento = tp.m_memento;
            if (this.m_icon_property == null) {
                this.m_icon_property = new IconProperty();
            }
            this.m_icon_property.setValue(tp.m_icon_property);
        }
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void updateBean(JETABean jbean) {
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        super.read(in.getSuperClassInput());
        int version = in.readVersion();
        this.m_title = (String)in.readObject("title");
        this.m_icon_property = (IconProperty)in.readObject("icon");
        this.m_memento = (FormMemento)in.readObject("form");
        this.m_form = null;
    }

    public void write(JETAObjectOutput out) throws IOException {
        super.write(out.getSuperClassOutput(JETAProperty.class));
        out.writeVersion(1);
        out.writeObject("title", this.m_title);
        out.writeObject("icon", this.m_icon_property);
        StateRequest state_req = StateRequest.SHALLOW_COPY;
        Object obj = JETARegistry.lookup("state.request");
        if (obj instanceof StateRequest) {
            state_req = (StateRequest)obj;
        }
        try {
            this.getForm();
            if (this.m_form != null) {
                out.writeObject("form", this.m_form.getExternalState(state_req));
            } else {
                out.writeObject("form", null);
            }
        }
        catch (Exception e) {
            FormsLogger.severe(e);
            out.writeObject("form", null);
        }
    }
}

