/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.xml.writer;

import com.jeta.forms.store.jml.dom.JMLNode;
import com.jeta.forms.store.jml.dom.TextJMLNode;
import com.jeta.forms.store.xml.XMLUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;

public class XMLWriter {
    private Writer m_writer;
    private static final int DEFAULT_INDENT = 1;
    private int m_indent_pos = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void write(Writer writer, JMLNode node) throws IOException {
        this.m_writer = writer;
        this.m_writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write(node);
    }

    private void write(JMLNode node) throws IOException {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        this.indent();
        if (node instanceof TextJMLNode) {
            TextJMLNode txtnode = (TextJMLNode)node;
            if (txtnode.getTextValue() != null) {
                this.m_writer.write(XMLUtils.escape(txtnode.getTextValue()));
            }
        } else {
            int index;
            this.m_writer.write(10);
            for (index = 0; index < this.m_indent_pos; ++index) {
                this.m_writer.write(32);
            }
            this.m_writer.write(60);
            this.m_writer.write(node.getNodeName());
            this.m_writer.write(32);
            this.writeAttributes(node);
            if (node.getChildCount() == 0) {
                this.m_writer.write(47);
                this.m_writer.write(">");
            } else {
                this.m_writer.write(">");
                for (index = 0; index < node.getChildCount(); ++index) {
                    JMLNode childnode = node.getNode(index);
                    this.write(childnode);
                }
                if (node.getChildCount() > 0 && !(node.getNode(node.getChildCount() - 1) instanceof TextJMLNode)) {
                    this.m_writer.write(10);
                    for (index = 0; index < this.m_indent_pos; ++index) {
                        this.m_writer.write(32);
                    }
                }
                this.m_writer.write("</");
                this.m_writer.write(node.getNodeName());
                this.m_writer.write(62);
            }
        }
        this.unindent();
    }

    private void writeAttributes(JMLNode node) throws IOException {
        Collection anames = node.getAttributeNames();
        Iterator iter = anames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String value = node.getAttribute(name);
            this.m_writer.write(name);
            this.m_writer.write("=\"");
            this.m_writer.write(XMLUtils.escape(value));
            this.m_writer.write("\"");
            if (!iter.hasNext()) continue;
            this.m_writer.write(32);
        }
    }

    private void indent() {
        ++this.m_indent_pos;
    }

    private void unindent() {
        --this.m_indent_pos;
    }

    static {
        $assertionsDisabled = !XMLWriter.class.desiredAssertionStatus();
    }
}

