/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.gui.utils;

import com.jeta.open.gui.framework.JETADialog;
import com.jeta.open.gui.framework.JETAPanel;
import com.jeta.open.registry.JETARegistry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.lang.reflect.Constructor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JETAToolbox {
    private static final String AVG_STR = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String APPLICATION_FRAME = "application.frame.window";
    public static final String WINDOWS_LF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void addItems(JComboBox cbox, Object[] items) {
        if (!$assertionsDisabled && cbox == null) {
            throw new AssertionError();
        }
        if (items == null || cbox == null) {
            return;
        }
        for (int index = 0; index < items.length; ++index) {
            cbox.addItem(items[index]);
        }
    }

    private static Component[] toComponentArray(JComponent[] components) {
        Component[] result = new Component[components.length];
        for (int index = 0; index < components.length; ++index) {
            result[index] = components[index];
        }
        return result;
    }

    public static int calculateAverageTextWidth(Component comp, int numCharacters) {
        if (comp == null) {
            return 0;
        }
        Font f = comp.getFont();
        FontMetrics metrics = comp.getFontMetrics(f);
        return metrics.stringWidth(AVG_STR) * numCharacters / AVG_STR.length();
    }

    public static void calculateReasonableComponentSize(Dimension d) {
        Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
        if (d.width > screensize.width) {
            d.width = screensize.width * 8 / 10;
        }
        if (d.height > screensize.height) {
            d.height = screensize.height * 8 / 10;
        }
    }

    public static void centerFrame(Window frame, float xpctWidth, float ypctWidth) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int frame_width = (int)((float)screenSize.width * xpctWidth);
        int frame_height = (int)((float)screenSize.height * ypctWidth);
        int left = (screenSize.width - frame_width) / 2;
        int top = (screenSize.height - frame_height) / 2;
        frame.setBounds(left, top, frame_width, frame_height);
    }

    public static void centerWindow(Window frame) {
        float width = frame.getWidth();
        float height = frame.getHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        float pctwidth = width / (float)screenSize.getWidth();
        float pctheight = height / (float)screenSize.getHeight();
        JETAToolbox.centerFrame(frame, pctwidth, pctheight);
    }

    public static void centerWindowChangeWidth(Window frame, float xpctWidth) {
        float height = frame.getHeight();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        float pctheight = height / (float)screenSize.getHeight();
        JETAToolbox.centerFrame(frame, xpctWidth, pctheight);
    }

    public static void copyToClipboard(String str) {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = kit.getSystemClipboard();
        StringSelection ss = new StringSelection(str);
        clipboard.setContents(ss, ss);
    }

    public static Dialog createDialog(Class dlgclass, Component owner, boolean bModal) {
        Object comp;
        Class[] cparams = new Class[2];
        Object[] params = new Object[2];
        if (owner == null && (comp = JETARegistry.lookup(APPLICATION_FRAME)) instanceof Component) {
            owner = (Component)comp;
        }
        if (owner instanceof Dialog) {
            cparams[0] = Dialog.class;
            params[0] = owner;
        } else if (owner instanceof Frame) {
            cparams[0] = Frame.class;
            params[0] = owner;
        } else if (owner == null) {
            cparams[0] = Frame.class;
            params[0] = null;
        } else {
            Window win = SwingUtilities.getWindowAncestor(owner);
            if (win instanceof Dialog) {
                cparams[0] = Dialog.class;
                params[0] = win;
            } else if (win instanceof Frame) {
                cparams[0] = Frame.class;
                params[0] = win;
            } else {
                cparams[0] = Frame.class;
                params[0] = null;
            }
        }
        cparams[1] = Boolean.TYPE;
        params[1] = bModal;
        try {
            Constructor ctor = dlgclass.getConstructor(cparams);
            return (Dialog)ctor.newInstance(params);
        }
        catch (Exception e) {
            System.out.println("Unable to construct dialg   parent class: " + cparams[0] + "  owner = " + owner);
            e.printStackTrace();
            return null;
        }
    }

    public static int getFrameBorderThickness() {
        if (JETAToolbox.isOSX()) {
            return 0;
        }
        return 4;
    }

    public static int getTitleBarHeight() {
        return 20;
    }

    public static JETADialog invokeDialog(JETAPanel view, Component owner, String title) {
        JETADialog dlg = (JETADialog)JETAToolbox.createDialog(JETADialog.class, owner, true);
        dlg.setPrimaryPanel(view);
        dlg.setTitle(title);
        dlg.setSize(dlg.getPreferredSize());
        dlg.showCenter();
        return dlg;
    }

    public static JETADialog invokeDialog(JETAPanel view, Component owner, String title, JComponent initialFocus) {
        JETADialog dlg = (JETADialog)JETAToolbox.createDialog(JETADialog.class, owner, true);
        dlg.setPrimaryPanel(view);
        dlg.setTitle(title);
        dlg.setSize(dlg.getPreferredSize());
        dlg.setInitialFocusComponent(initialFocus);
        dlg.showCenter();
        return dlg;
    }

    public static boolean isAquaLookAndFeel() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        return laf.getName().startsWith("Mac OS X");
    }

    public static boolean isOSX() {
        try {
            return System.getProperty("mrj.version") != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWindows() {
        try {
            String result = System.getProperty("os.name");
            if (result != null && (result = result.toLowerCase()).indexOf("windows") >= 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isWindowsLookAndFeel() {
        return WINDOWS_LF.equals(UIManager.getLookAndFeel().getClass().getName());
    }

    public static void setReasonableWindowSize(Component window, Dimension d) {
        JETAToolbox.calculateReasonableComponentSize(d);
        window.setSize(d);
    }

    static {
        $assertionsDisabled = !JETAToolbox.class.desiredAssertionStatus();
    }
}

