/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.circle3p;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class Circle2PEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    protected FeatureStore featureStore;
    protected EditingServiceParameter firstPoint;
    protected EditingServiceParameter secondPoint;
    protected Map<EditingServiceParameter, Object> values;

    public Circle2PEditingProvider(ProviderServices services, DynObject parameters) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.firstPoint = new DefaultEditingServiceParameter("first_point", "first_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.secondPoint = new DefaultEditingServiceParameter("second_point", "second_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
    }

    public EditingServiceParameter next() {
        if (this.values != null) {
            if (this.values.get(this.firstPoint) == null) {
                return this.firstPoint;
            }
            if (this.values.get(this.secondPoint) == null) {
                return this.secondPoint;
            }
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        drawingStatus.setPreviewSymbol(previewSymbol);
        if (this.values != null) {
            Point firstPointValue = (Point)this.values.get(this.firstPoint);
            Point secondPointValue = (Point)this.values.get(this.secondPoint);
            EditingProviderServices editingProviderServices = this.getProviderServices();
            if (firstPointValue != null && secondPointValue == null) {
                try {
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    Line line = GeometryUtils.createLine((Point)firstPointValue, (Point)mousePosition, (int)subtype);
                    drawingStatus.addStatus((Geometry)line, auxiliaryLineSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)firstPointValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)mousePosition, auxiliaryPointSymbolEditing, "");
                    Point center = GeometryUtils.getMidPoint((Point)firstPointValue, (Point)mousePosition, (int)subtype);
                    drawingStatus.addStatus((Geometry)center, auxiliaryPointSymbolEditing, "");
                    double radius = firstPointValue.distance((Geometry)mousePosition) / 2.0;
                    this.addTemporaryGeometryToDrawingStatus(drawingStatus, subtype, center, radius);
                    drawingStatus.addStatus((Geometry)center, auxiliaryPointSymbolEditing, "");
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
        }
        return drawingStatus;
    }

    protected void addTemporaryGeometryToDrawingStatus(DefaultDrawingStatus drawingStatus, int subtype, Point center, double radius) throws CreateGeometryException {
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Circle circle = (Circle)geomManager.create(11, subtype);
        circle.setPoints(center, radius);
        drawingStatus.addStatus((Geometry)circle, polygonSymbolEditing, "");
        drawingStatus.addStatus((Geometry)circle, drawingStatus.getPreviewSymbol(), "");
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.firstPoint);
        parameters.add(this.secondPoint);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (parameter == this.firstPoint) {
            if (value instanceof Point) {
                this.values.put(parameter, value);
                return;
            }
        } else if (parameter == this.secondPoint && value instanceof Point) {
            this.values.put(parameter, value);
            return;
        }
        throw new InvalidEntryException(null);
    }

    public Geometry finish() throws FinishServiceException {
        if (this.values != null) {
            Point firstPointValue = (Point)this.values.get(this.firstPoint);
            Point secondPointValue = (Point)this.values.get(this.secondPoint);
            EditingProviderServices editingProviderServices = this.getProviderServices();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                Point center = GeometryUtils.getMidPoint((Point)firstPointValue, (Point)secondPointValue, (int)subtype);
                double radius = firstPointValue.distance((Geometry)secondPointValue) / 2.0;
                Circle circle = GeometryUtils.createCircle((Point)center, (double)radius, (int)subtype);
                return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)circle);
            }
            catch (Exception e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
        throw new FinishServiceException(null);
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry circle = this.finish();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        editingProviderServices.insertGeometryIntoFeatureStore(circle, this.featureStore);
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-circle-3p";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

